/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.cls;

public enum ClassGeneration {
    YOUNG(" Young", 0),
    OLD("Old", 1),
    PERM("Perm", 2),
    UNKNOWN("Unknown", 3);

    private final String name;
    private final short id;

    private ClassGeneration(String name, short id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public short getId() {
        return this.id;
    }

    public static ClassGeneration getDataType(int index) {
        ClassGeneration[] values = ClassGeneration.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return UNKNOWN;
    }

    public static int getIndexFor(ClassGeneration type) {
        ClassGeneration[] values = ClassGeneration.values();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].name.equals(type.name)) continue;
            return i;
        }
        return ClassGeneration.UNKNOWN.id;
    }
}

