/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.resource.GenericResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractFilterByThreadAnnotation
extends GenericResourceNameElement {
    private static final int VERSION = 0;
    private final String key;
    private final String[] annotations;
    private final ThreadFilter filter;

    public AbstractFilterByThreadAnnotation(String key, String[] annotations) {
        this.key = key;
        this.annotations = annotations;
        this.filter = new ThreadFilter();
        this.filter.filterAnnotation(key, annotations);
    }

    public AbstractFilterByThreadAnnotation(ResourceReader reader) throws IOException {
        super(reader);
        reader.readVersion(0, 0);
        this.key = reader.readString();
        this.annotations = new String[reader.readInt32()];
        for (int i = 0; i < this.annotations.length; ++i) {
            this.annotations[i] = reader.readString();
        }
        this.filter = new ThreadFilter();
        this.filter.filterAnnotation(this.key, this.annotations);
    }

    public String getKey() {
        return this.key;
    }

    public String[] getAnnotations() {
        return this.annotations;
    }

    public ThreadFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof AbstractFilterByThreadAnnotation && ((Object)((Object)this)).getClass() == obj.getClass()) {
            AbstractFilterByThreadAnnotation other = (AbstractFilterByThreadAnnotation)((Object)obj);
            return other.filter.equals((Object)this.filter);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ ((Object)((Object)this)).getClass().hashCode() ^ this.filter.hashCode();
    }

    public String toString() {
        return "a filter by thread annotation '" + this.key + "' for the following annotations: " + Arrays.toString(this.annotations);
    }

    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(0);
        writer.writeString(this.key);
        writer.writeInt32(this.annotations.length);
        for (String annotation : this.annotations) {
            writer.writeString(annotation);
        }
    }
}

