/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.GenericResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractFilterByThreadId
extends GenericResourceNameElement {
    private static final int VERSION = 0;
    private final long[] ids;
    private final UTF8String[] names;
    private final ThreadFilter filter;

    public AbstractFilterByThreadId(long[] ids, UTF8String[] names) {
        this.ids = ids;
        this.names = names;
        this.filter = new ThreadFilter();
        this.filter.filterThread(ids);
    }

    public AbstractFilterByThreadId(ResourceReader reader) throws IOException {
        super(reader);
        reader.readVersion(0, 0);
        this.ids = new long[reader.readInt32()];
        this.names = new UTF8String[this.ids.length];
        for (int i = 0; i < this.names.length; ++i) {
            this.ids[i] = reader.readInt64();
            this.names[i] = reader.readInternedUTF();
        }
        this.filter = new ThreadFilter();
        this.filter.filterThread(this.ids);
    }

    public long[] getIds() {
        return this.ids;
    }

    public UTF8String[] getNames() {
        return this.names;
    }

    public ThreadFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof AbstractFilterByThreadId && ((Object)((Object)this)).getClass() == obj.getClass()) {
            AbstractFilterByThreadId other = (AbstractFilterByThreadId)((Object)obj);
            return other.filter.equals((Object)this.filter);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ ((Object)((Object)this)).getClass().hashCode() ^ this.filter.hashCode();
    }

    public String toString() {
        return "a filter by thread ids for ids " + Arrays.toString(this.ids) + " and name " + Arrays.toString(this.names);
    }

    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(0);
        writer.writeInt32(this.ids.length);
        for (int i = 0; i < this.ids.length; ++i) {
            writer.writeInt64(this.ids[i]);
            writer.writeUTF(this.names[i]);
        }
    }
}

