/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.GenericResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractFilterByThreadName
extends GenericResourceNameElement {
    private static final int VERSION = 0;
    private final UTF8String[] names;
    private final ThreadFilter filter;

    public AbstractFilterByThreadName(UTF8String[] names) {
        this.names = names;
        this.filter = new ThreadFilter();
        this.filter.filterNames(names);
    }

    public AbstractFilterByThreadName(ResourceReader reader) throws IOException {
        super(reader);
        reader.readVersion(0, 0);
        this.names = new UTF8String[reader.readInt32()];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = reader.readInternedUTF();
        }
        this.filter = new ThreadFilter();
        this.filter.filterNames(this.names);
    }

    public UTF8String[] getNames() {
        return this.names;
    }

    public ThreadFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof AbstractFilterByThreadName && ((Object)((Object)this)).getClass() == obj.getClass()) {
            AbstractFilterByThreadName other = (AbstractFilterByThreadName)((Object)obj);
            return other.filter.equals((Object)this.filter);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ ((Object)((Object)this)).getClass().hashCode() ^ this.filter.hashCode();
    }

    public String toString() {
        return "a filter by thread names: " + Arrays.toString(this.names);
    }

    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(0);
        writer.writeInt32(this.names.length);
        for (UTF8String name : this.names) {
            writer.writeUTF(name);
        }
    }
}

