/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class ElementWithFilterEntities {
    private static final int VERSION = 0;
    private final FilterEntity[] entities;

    protected ElementWithFilterEntities(FilterEntity[] entities) {
        this.entities = entities;
    }

    protected ElementWithFilterEntities(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int nrOfEnities = reader.readInt32();
        this.entities = new FilterEntity[nrOfEnities];
        for (int i = 0; i < nrOfEnities; ++i) {
            this.entities[i] = new FilterEntity(reader);
        }
    }

    public FilterEntity[] getEntities() {
        return this.entities;
    }

    public int hashCode() {
        return Arrays.hashCode(this.entities);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementWithFilterEntities) {
            return Arrays.equals(this.entities, ((ElementWithFilterEntities)obj).entities);
        }
        return false;
    }

    protected String getEnititesAsString(boolean startWithNewLine) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        if (startWithNewLine) {
            ps.println();
        }
        for (int i = 0; i < this.entities.length; ++i) {
            ps.println(this.entities[i].toString());
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    protected void writeEntites(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.entities.length);
        for (FilterEntity filter : this.entities) {
            filter.write(writer);
        }
    }
}

