/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class ElementWithFilterEntityPaths {
    private static final int VERSION = 0;
    private final FilterEntity[][] paths;

    protected ElementWithFilterEntityPaths(FilterEntity[][] paths) {
        this.paths = paths;
    }

    protected ElementWithFilterEntityPaths(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int nrOfPaths = reader.readInt32();
        this.paths = new FilterEntity[nrOfPaths][];
        for (int i = 0; i < nrOfPaths; ++i) {
            int nrOfEnities = reader.readInt32();
            this.paths[i] = new FilterEntity[nrOfEnities];
            for (int j = 0; j < nrOfEnities; ++j) {
                this.paths[i][j] = new FilterEntity(reader);
            }
        }
    }

    public FilterEntity[][] getPaths() {
        return this.paths;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.paths.length; ++i) {
            result ^= Arrays.hashCode(this.paths[i]);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementWithFilterEntityPaths) {
            ElementWithFilterEntityPaths other = (ElementWithFilterEntityPaths)obj;
            if (this.paths.length != other.paths.length) {
                return false;
            }
            for (int i = 0; i < this.paths.length; ++i) {
                if (Arrays.equals(this.paths[i], other.paths[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getPathsAsString(boolean startWithNewLine) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        if (startWithNewLine) {
            ps.println();
        }
        for (int i = 0; i < this.paths.length; ++i) {
            ps.println(Arrays.toString(this.paths[i]));
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    protected void writePaths(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.paths.length);
        for (FilterEntity[] path : this.paths) {
            writer.writeInt32(path.length);
            for (FilterEntity entity : path) {
                entity.write(writer);
            }
        }
    }
}

