/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class ElementWithMethodFilters {
    private static final int VERSION = 0;
    private final MethodFilter[] filters;

    protected ElementWithMethodFilters(MethodFilter[] filters) {
        this.filters = filters;
    }

    protected ElementWithMethodFilters(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int nrOfFilters = reader.readInt32();
        this.filters = new MethodFilter[nrOfFilters];
        for (int i = 0; i < nrOfFilters; ++i) {
            this.filters[i] = new MethodFilter(reader);
        }
    }

    public MethodFilter[] getFilters() {
        return this.filters;
    }

    public int hashCode() {
        return Arrays.hashCode(this.filters);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementWithMethodFilters) {
            ElementWithMethodFilters other = (ElementWithMethodFilters)obj;
            return Arrays.equals(this.filters, other.filters);
        }
        return false;
    }

    protected String getFiltersAsString(boolean startWithNewLine) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        if (startWithNewLine) {
            ps.println();
        }
        for (int i = 0; i < this.filters.length; ++i) {
            ps.println(this.filters[i].asString());
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    protected void writeFilters(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.filters.length);
        for (MethodFilter filter : this.filters) {
            filter.write(writer);
        }
    }
}

