/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.util.MethodPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public abstract class ElementWithMethodPath {
    private static final int VERSION = 0;
    private final MethodLocation[][] paths;

    protected ElementWithMethodPath(MethodLocation[][] paths) {
        this.paths = paths;
    }

    protected ElementWithMethodPath(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int nrOfPaths = reader.readInt32();
        this.paths = new MethodLocation[nrOfPaths][];
        for (int i = 0; i < nrOfPaths; ++i) {
            int nrOfMethods = reader.readInt32();
            this.paths[i] = new MethodLocation[nrOfMethods];
            for (int j = 0; j < nrOfMethods; ++j) {
                this.paths[i][j] = reader.readMethodLocation();
            }
        }
    }

    public MethodPath[] getPaths() {
        MethodPath[] result = new MethodPath[this.paths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MethodPath(this.paths[i]);
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.paths.length; ++i) {
            result ^= Arrays.hashCode(this.paths[i]);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementWithMethodPath) {
            ElementWithMethodPath other = (ElementWithMethodPath)obj;
            if (this.paths.length != other.paths.length) {
                return false;
            }
            for (int i = 0; i < this.paths.length; ++i) {
                if (Arrays.equals(this.paths[i], other.paths[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected String getPathsAsString(boolean startWithNewLine) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        if (startWithNewLine) {
            ps.println();
        }
        for (int i = 0; i < this.paths.length; ++i) {
            ps.println(Arrays.toString(this.paths[i]));
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    protected void writePaths(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.paths.length);
        for (MethodLocation[] path : this.paths) {
            writer.writeInt32(path.length);
            for (MethodLocation method : path) {
                writer.writeMethodLocation(method);
            }
        }
    }
}

