/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FileFilterElement;
import com.sap.jvm.profiling.snapshot.filter.FileFilter;
import com.sap.jvm.profiling.snapshot.resource.FileFilterResource;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class FilterByFileFilterResource
implements FileFilterElement {
    private static final String TAG = "filter by a file filter resource";
    private static final int VERSION = 0;
    private final ResourceName filterResourceName;

    public FilterByFileFilterResource() {
        this((ResourceName)null);
    }

    public FilterByFileFilterResource(ResourceName filterResourceName) {
        this.filterResourceName = filterResourceName;
    }

    public FilterByFileFilterResource(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.filterResourceName = reader.readResourceName();
    }

    @Override
    public FileFilter getFilter() {
        Object filterResource = null;
        try {
            filterResource = this.filterResourceName.getResourceManager().get(this.filterResourceName, new ProgressReporter());
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not get filter resource");
        }
        if (filterResource == null) {
            filterResource = new FileFilter();
        }
        return ((FileFilterResource)filterResource).getFilter();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByFileFilterResource) {
            FilterByFileFilterResource other = (FilterByFileFilterResource)obj;
            return other.filterResourceName.equals((Object)this.filterResourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.filterResourceName.hashCode();
    }

    public String toString() {
        return "a filter by file filter resource";
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.filterResourceName.write(writer);
    }

    public String getTag() {
        return TAG;
    }
}

