/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FileFilterElement;
import com.sap.jvm.profiling.snapshot.filter.FileFilter;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByFileId
implements FileFilterElement {
    private static final String TAG = "filter by file ids";
    private static final int VERSION = 0;
    private final long[] ids;
    private final long[] displayIds;
    private final long[] fds;
    private final FileFilter filter;

    public FilterByFileId() {
        this(new long[0], new long[0], new long[0]);
    }

    public FilterByFileId(long[] ids, long[] displayIds, long[] fds) {
        assert (ids.length == displayIds.length);
        assert (ids.length == fds.length);
        this.ids = ids;
        this.displayIds = displayIds;
        this.fds = fds;
        this.filter = new FileFilter();
        this.filter.filterIds(ids);
    }

    public FilterByFileId(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int size = reader.readInt32();
        this.ids = this.readLongs(reader, size);
        this.displayIds = this.readLongs(reader, size);
        this.fds = this.readLongs(reader, size);
        this.filter = new FileFilter();
        this.filter.filterIds(this.ids);
    }

    public long[] getIds() {
        return this.ids;
    }

    public long[] getDisplayIds() {
        return this.displayIds;
    }

    public long[] getFds() {
        return this.fds;
    }

    @Override
    public FileFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByFileId) {
            FilterByFileId other = (FilterByFileId)obj;
            return other.filter.equals(this.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return "a filter by file ids: " + Arrays.toString(this.ids);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.ids.length);
        for (long id : this.ids) {
            writer.writeInt64(id);
        }
        for (long id : this.displayIds) {
            writer.writeInt64(id);
        }
        for (long id : this.fds) {
            writer.writeInt64(id);
        }
    }

    private long[] readLongs(ResourceReader reader, int size) throws IOException {
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = reader.readInt64();
        }
        return result;
    }

    public String getTag() {
        return TAG;
    }
}

