/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.FileFilterElement;
import com.sap.jvm.profiling.snapshot.filter.FileFilter;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByFileName
implements FileFilterElement {
    private static final String TAG = "filter by file names";
    private static final int VERSION = 0;
    private final UTF8String[] names;
    private final FileFilter filter;

    public FilterByFileName() {
        this(new UTF8String[0]);
    }

    public FilterByFileName(UTF8String[] names) {
        this.names = names;
        this.filter = new FileFilter();
        this.filter.filterNames(names);
    }

    public FilterByFileName(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.names = new UTF8String[reader.readInt32()];
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i] = reader.readInternedUTF();
        }
        this.filter = new FileFilter();
        this.filter.filterNames(this.names);
    }

    public UTF8String[] getNames() {
        return this.names;
    }

    @Override
    public FileFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByFileName) {
            FilterByFileName other = (FilterByFileName)obj;
            return other.filter.equals(this.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return "a filter by file names: " + Arrays.toString(this.names);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.names.length);
        for (UTF8String name : this.names) {
            writer.writeUTF(name);
        }
    }

    public String getTag() {
        return TAG;
    }
}

