/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.GcEventTypeFilterElement;
import com.sap.jvm.profiling.snapshot.filter.GcEventTypeFilter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FilterByGcEventType
implements GcEventTypeFilterElement {
    private static final String TAG = "filter by gc event types";
    private static final int VERSION = 1;
    private final Set<GcEventType> eventTypes;
    private final GcEventTypeFilter filter;
    private String name;
    private boolean custom;

    public FilterByGcEventType() {
        this(Collections.emptySet(), null, false);
    }

    public FilterByGcEventType(Set<GcEventType> eventTypes, String name, boolean custom) {
        this.eventTypes = eventTypes;
        this.filter = new GcEventTypeFilter();
        this.name = name != null ? name : I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Events");
        this.custom = custom;
        this.filter.filterIds(eventTypes);
    }

    public FilterByGcEventType(ResourceReader reader) throws IOException {
        int version = reader.readVersion(0, 1);
        int size = reader.readInt32();
        this.eventTypes = new HashSet<GcEventType>();
        for (int i = 0; i < size; ++i) {
            String typeName = reader.readString();
            try {
                this.eventTypes.add(GcEventType.valueOf((String)typeName));
                continue;
            }
            catch (IllegalArgumentException e) {
                Trace.error((Throwable)e, () -> "Could not read event type " + typeName + " for GC filter by event type");
            }
        }
        if (version >= 1) {
            this.name = reader.readString();
            this.custom = reader.readBoolean();
        } else {
            this.name = I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"GC Events");
            this.custom = false;
        }
        this.filter = new GcEventTypeFilter();
        this.filter.filterIds(this.eventTypes);
    }

    public Set<GcEventType> getEventTypes() {
        return this.eventTypes;
    }

    @Override
    public GcEventTypeFilter getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByGcEventType) {
            FilterByGcEventType other = (FilterByGcEventType)obj;
            return other.filter.equals(this.filter) && other.name.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        return "a filter by gc event types: " + this.name + ": " + Arrays.toString(this.eventTypes.toArray());
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(1);
        writer.writeInt32(this.eventTypes.size());
        for (GcEventType type : this.eventTypes) {
            writer.writeString(type.name());
        }
        writer.writeString(this.name);
        writer.writeBoolean(this.custom);
    }

    public String getTag() {
        return TAG;
    }
}

