/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.MethodParameterFilterElement;
import com.sap.jvm.profiling.snapshot.filter.MethodParameterFilter;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByInvocationIds
implements MethodParameterFilterElement {
    private static final String TAG = "filter by method parameter invocation ids";
    private static final int VERSION = 2;
    private final long[] invocationIds;

    public FilterByInvocationIds() {
        this(new long[0]);
    }

    public FilterByInvocationIds(long[] invocationIds) {
        this.invocationIds = invocationIds;
    }

    public FilterByInvocationIds(ResourceReader reader) throws IOException {
        block5: {
            int version = reader.readVersion(0, 2);
            this.invocationIds = new long[reader.readInt32()];
            for (int i = 0; i < this.invocationIds.length; ++i) {
                this.invocationIds[i] = reader.readInt64();
            }
            if (version >= 2) break block5;
            int toRead = reader.readInt32();
            if (version == 0) {
                for (int i = 0; i < toRead; ++i) {
                    reader.readInt64();
                }
            } else {
                for (int i = 0; i < toRead; ++i) {
                    reader.readInt32();
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByInvocationIds) {
            FilterByInvocationIds other = (FilterByInvocationIds)obj;
            return Arrays.equals(this.invocationIds, other.invocationIds);
        }
        return false;
    }

    public int hashCode() {
        return 0x768276 ^ Arrays.hashCode(this.invocationIds);
    }

    public String toString() {
        return "Filter by the invocation ids " + Arrays.toString(this.invocationIds);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(2);
        writer.writeInt32(this.invocationIds.length);
        for (int i = 0; i < this.invocationIds.length; ++i) {
            writer.writeInt64(this.invocationIds[i]);
        }
    }

    public final long[] getInvocationIds() {
        return this.invocationIds;
    }

    @Override
    public void addToFilter(MethodParameterFilter filter) {
        filter.filterByInvocationIds(this.invocationIds);
    }

    public String getTag() {
        return TAG;
    }
}

