/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.SocketFilterElement;
import com.sap.jvm.profiling.snapshot.filter.SocketFilter;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByNetworkHost
implements SocketFilterElement {
    private static final String TAG = "filter by network hosts";
    private static final int VERSION = 0;
    private final NetworkHost[] hosts;
    private final SocketFilter filter;

    public FilterByNetworkHost() {
        this(new NetworkHost[0]);
    }

    public FilterByNetworkHost(NetworkHost[] hosts) {
        this.hosts = hosts;
        this.filter = new SocketFilter();
        this.filter.filterHosts(hosts);
    }

    public FilterByNetworkHost(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.hosts = new NetworkHost[reader.readInt32()];
        for (int i = 0; i < this.hosts.length; ++i) {
            this.hosts[i] = new NetworkHost(reader.readString(), IpAddressUtil.read((ResourceReader)reader));
        }
        this.filter = new SocketFilter();
        this.filter.filterHosts(this.hosts);
    }

    public NetworkHost[] getHosts() {
        return this.hosts;
    }

    @Override
    public SocketFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByNetworkHost) {
            FilterByNetworkHost other = (FilterByNetworkHost)obj;
            return other.filter.equals(this.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return "a filter by network hosts: " + Arrays.toString(this.hosts);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.hosts.length);
        for (NetworkHost host : this.hosts) {
            writer.writeStringSafe(host.getHostname());
            IpAddressUtil.write((ResourceWriter)writer, (IpAddress)host.getAddress());
        }
    }

    public String getTag() {
        return TAG;
    }
}

