/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.SocketFilterElement;
import com.sap.jvm.profiling.snapshot.filter.SocketFilter;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByNetworkService
implements SocketFilterElement {
    private static final String TAG = "filter by network services";
    private static final int VERSION = 0;
    private final NetworkService[] services;
    private final SocketFilter filter;

    public FilterByNetworkService() {
        this(new NetworkService[0]);
    }

    public FilterByNetworkService(NetworkService[] services) {
        this.services = services;
        this.filter = new SocketFilter();
        this.filter.filterServices(services);
    }

    public FilterByNetworkService(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.services = new NetworkService[reader.readInt32()];
        for (int i = 0; i < this.services.length; ++i) {
            this.services[i] = new NetworkService(reader.readString(), reader.readUint16(), NetworkConnectionSideType.get(reader.readInt8()), reader.readBoolean());
        }
        this.filter = new SocketFilter();
        this.filter.filterServices(this.services);
    }

    public NetworkService[] getServices() {
        return this.services;
    }

    @Override
    public SocketFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByNetworkService) {
            FilterByNetworkService other = (FilterByNetworkService)obj;
            return other.filter.equals(this.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return "a filter by network services: " + Arrays.toString(this.services);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.services.length);
        for (NetworkService service : this.services) {
            writer.writeStringSafe(service.getServiceName());
            writer.writeUint16(service.getPort());
            writer.writeInt8(service.getSideType().getValue());
            writer.writeBoolean(service.isStream());
        }
    }

    public String getTag() {
        return TAG;
    }
}

