/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.MethodParameterFilterElement;
import com.sap.jvm.profiling.snapshot.filter.MethodParameterFilter;
import java.io.IOException;
import java.util.Arrays;

public final class FilterByParameterValues
implements MethodParameterFilterElement {
    private static final String TAG = "filter by method parameter values";
    private static final int VERSION = 0;
    private final Parameter[] values;

    public FilterByParameterValues() {
        this(new Parameter[0]);
    }

    public FilterByParameterValues(Parameter[] values) {
        this.values = values;
    }

    public FilterByParameterValues(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.values = new Parameter[reader.readInt32()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Parameter.read((ResourceReader)reader);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterByParameterValues) {
            FilterByParameterValues other = (FilterByParameterValues)obj;
            return Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return 0x7AF2662 ^ Arrays.hashCode(this.values);
    }

    public String toString() {
        return "Filter by the values " + Arrays.toString(this.values);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].write(writer);
        }
    }

    public final Parameter[] getValues() {
        return this.values;
    }

    @Override
    public void addToFilter(MethodParameterFilter filter) {
        filter.filterByValues(this.values);
    }

    public String getTag() {
        return TAG;
    }
}

