/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.SocketFilterElement;
import com.sap.jvm.profiling.snapshot.filter.SocketFilter;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import java.io.IOException;
import java.util.Arrays;

public final class FilterBySocketConnection
implements SocketFilterElement {
    private static final String TAG = "filter by socket connections";
    private static final int VERSION = 0;
    private final NetworkConnection[] connections;
    private final SocketFilter filter;

    public FilterBySocketConnection() {
        this(new NetworkConnection[0]);
    }

    public FilterBySocketConnection(NetworkConnection[] connections) {
        this.connections = connections;
        this.filter = new SocketFilter();
        this.filter.filterConnections(connections);
    }

    public FilterBySocketConnection(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.connections = new NetworkConnection[reader.readInt32()];
        for (int i = 0; i < this.connections.length; ++i) {
            this.connections[i] = new NetworkConnection(IpAddressUtil.read((ResourceReader)reader), reader.readUint16(), IpAddressUtil.read((ResourceReader)reader), reader.readUint16(), reader.readBoolean());
        }
        this.filter = new SocketFilter();
        this.filter.filterConnections(this.connections);
    }

    public NetworkConnection[] getConnections() {
        return this.connections;
    }

    @Override
    public SocketFilter getFilter() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterBySocketConnection) {
            FilterBySocketConnection other = (FilterBySocketConnection)obj;
            return other.filter.equals(this.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return "a filter by socket connections: " + Arrays.toString(this.connections);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.connections.length);
        for (NetworkConnection connection : this.connections) {
            IpAddressUtil.write((ResourceWriter)writer, (IpAddress)connection.getLocalAddress());
            writer.writeUint16(connection.getLocalPort());
            IpAddressUtil.write((ResourceWriter)writer, (IpAddress)connection.getRemoteAddress());
            writer.writeUint16(connection.getRemotePort());
            writer.writeBoolean(connection.isStreamSocket());
        }
    }

    public String getTag() {
        return TAG;
    }
}

