/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GcEventColumnsElement
implements ResourceNameElement {
    private static final String TAG = "select gc event value columns";
    private static final int VERSION = 1;
    private final List<GcEventStatisticValueElement> valueElements;
    private final List<String> defaultVisibleColumnTags;

    public GcEventColumnsElement() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public GcEventColumnsElement(List<GcEventStatisticValueElement> valueElements, List<String> defaultVisibleColumnTags) {
        this.valueElements = valueElements;
        this.defaultVisibleColumnTags = defaultVisibleColumnTags;
    }

    public GcEventColumnsElement(ResourceReader reader) throws IOException {
        int i;
        reader.readVersion(0, 1);
        int size = reader.readInt32();
        this.valueElements = new ArrayList<GcEventStatisticValueElement>(size);
        for (i = 0; i < size; ++i) {
            String elementName = reader.readString();
            GcEventStatisticValueElement element = GcEventStatisticValueElement.valueOf(elementName);
            this.valueElements.add(element);
        }
        size = reader.readInt32();
        this.defaultVisibleColumnTags = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            String tag = reader.readString();
            this.defaultVisibleColumnTags.add(tag);
        }
    }

    public void write(ResourceWriter writer) throws IOException {
        int i;
        writer.writeVersion(1);
        writer.writeInt32(this.valueElements.size());
        for (i = 0; i < this.valueElements.size(); ++i) {
            GcEventStatisticValueElement element = this.valueElements.get(i);
            writer.writeString(element.name());
        }
        writer.writeInt32(this.defaultVisibleColumnTags.size());
        for (i = 0; i < this.defaultVisibleColumnTags.size(); ++i) {
            writer.writeString(this.defaultVisibleColumnTags.get(i));
        }
    }

    public List<GcEventStatisticValueElement> getValueElements() {
        return this.valueElements;
    }

    public List<String> getDefaultVisibleColumnTags() {
        return this.defaultVisibleColumnTags;
    }

    public String getTag() {
        return TAG;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GcEventColumnsElement) {
            GcEventColumnsElement other = (GcEventColumnsElement)obj;
            return other.valueElements.equals(this.valueElements) && other.defaultVisibleColumnTags.equals(this.defaultVisibleColumnTags);
        }
        return false;
    }

    public int hashCode() {
        return this.valueElements.hashCode() + this.defaultVisibleColumnTags.hashCode();
    }

    public String toString() {
        return "select gc event value columns: " + Arrays.toString(this.valueElements.toArray());
    }
}

