/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.GenericResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotElement;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.elements.SnapshotTypeTag;
import java.io.IOException;

public abstract class GenericSnapshotElement
extends GenericResourceNameElement
implements SnapshotElement {
    private final int id;
    private final SnapshotType type;

    public GenericSnapshotElement(int id) {
        this.id = id;
        this.type = this.getClass().getAnnotation(SnapshotTypeTag.class).value();
        assert (this.type != null);
    }

    public GenericSnapshotElement(ResourceReader reader) throws IOException {
        super(reader);
        this.id = reader.readInt32();
        this.type = this.getClass().getAnnotation(SnapshotTypeTag.class).value();
        assert (this.type != null);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.id == ((GenericSnapshotElement)obj).id;
    }

    public int hashCode() {
        return super.hashCode() ^ this.id;
    }

    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt32(this.id);
    }

    public SnapshotType getType() {
        return this.type;
    }
}

