/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.ElementWithMethodFilters;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class InlineByPredefinedFilter
extends ElementWithMethodFilters
implements ResourceNameElement {
    private boolean showContext = true;
    private final PredefinedFilter choosenFilter;
    private static final String TAG = "create predefined filter inliner";

    public InlineByPredefinedFilter() {
        super(new MethodFilter[0]);
        this.choosenFilter = null;
    }

    public InlineByPredefinedFilter(PredefinedFilter filter, ProfilingSession session) {
        super(InlineByPredefinedFilter.createMethodFilters(filter, session));
        this.choosenFilter = filter;
    }

    public InlineByPredefinedFilter(ResourceReader reader) throws IOException {
        super(reader);
        String filterName = reader.readString();
        this.choosenFilter = PredefinedFilter.valueOf(filterName);
        this.showContext = reader.readBoolean();
    }

    public MethodFilter getFilter() {
        return this.getFilters()[0];
    }

    public boolean getShowCreationContext() {
        return this.showContext;
    }

    public void setShowCreationContext(boolean showContext) {
        this.showContext = showContext;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InlineByPredefinedFilter) {
            return this.choosenFilter.equals((Object)((InlineByPredefinedFilter)obj).choosenFilter);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x23346273 ^ this.choosenFilter.hashCode();
    }

    public String toString() {
        return "an inliner using the predefined filter " + this.choosenFilter.filterName;
    }

    public void write(ResourceWriter writer) throws IOException {
        this.writeFilters(writer);
        writer.writeString(this.choosenFilter.name());
        writer.writeBoolean(this.showContext);
    }

    private static MethodFilter[] createMethodFilters(PredefinedFilter filter, ProfilingSession session) {
        ClassFilter classFilter = null;
        try {
            classFilter = new ClassFilter(session, filter.filterName, filter.pattern);
        }
        catch (FilterParseException e) {
            Trace.error((Throwable)e, () -> "Error parsing the predefined inlining filter " + filter.filterName);
        }
        MethodFilter result = new MethodFilter(classFilter, filter.displayName);
        return new MethodFilter[]{result};
    }

    public String getTag() {
        return TAG;
    }

    public static enum PredefinedFilter {
        JDK_IO_CLASSES("JDK IO classes", I18n._ss((String)"FilterDefinitionName", (String)"JDK I/O classes"), "java.io.* || java.nio.* || java.util.zip.* || java.util.jar.* || sun.nio.*"),
        JDK_NETWORK_CLASSES("JDK Network IO classes", I18n._ss((String)"FilterDefinitionName", (String)"JDK Network I/O classes"), "java.io.* || java.net.* || java.nio.* || sun.net.* || sun.nio.* || sun.security.ssl.*"),
        JDK_CLASSES("JDK classes", I18n._tss((I18n.TextType)I18n.TextType.XFLD, (String)"FilterDefinitionName", (String)"JDK classes"), "java.* || javax.* ||  com.sap.jvm.* || sun.* || sunw.* ||\norg.ietf.* || org.omg.* || org.w3c.* || org.xml.* ||\ncom.sun.accessibility.* || com.sun.beans.* || com.sun.corba.* ||\ncom.sun.image.* || com.sun.imageio.* || com.sun.inputmethods.* ||\ncom.sun.jarsigner.* || com.sun.java.* || com.sun.java_cup.* ||\ncom.sun.java2d.* || com.sun.javadoc.* || com.sun.jdi.* ||\ncom.sun.jlex.* || com.sun.jmx.* || com.sun.jndi.* ||\ncom.sun.management.* || com.sun.media.* || com.sun.mirror.* ||\ncom.sun.naming.* || com.sun.org.* || com.sun.rmi.* ||\ncom.sun.rowset.* || com.sun.security.* || com.sun.swing.* ||\ncom.sun.tools.*");

        public final String filterName;
        public final String displayName;
        public final String pattern;

        private PredefinedFilter(String name, String displayName, String pattern) {
            this.filterName = name;
            this.displayName = displayName;
            this.pattern = pattern;
        }
    }
}

