/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import java.io.IOException;

public class NarrowSnapshotByPacketNr
implements SnapshotDefiningElement {
    private static final String TAG = "narrow snapshot by packets numbers";
    private final long startPacket;
    private final long endPacket;
    private final long startTimestamp;
    private final long endTimestamp;

    public NarrowSnapshotByPacketNr() {
        this(0L, 0L, 0L, 0L);
    }

    public NarrowSnapshotByPacketNr(long startTimestamp, long endTimestamp, long startPackets, long endPackets) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.startPacket = startPackets;
        this.endPacket = endPackets;
    }

    public NarrowSnapshotByPacketNr(ResourceReader reader) throws IOException {
        this.startTimestamp = reader.readInt64();
        this.endTimestamp = reader.readInt64();
        this.startPacket = reader.readInt64();
        this.endPacket = reader.readInt64();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NarrowSnapshotByPacketNr) {
            NarrowSnapshotByPacketNr other = (NarrowSnapshotByPacketNr)obj;
            return this.startPacket == other.startPacket && this.endPacket == other.endPacket;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.startPacket).hashCode() ^ Long.valueOf(this.endPacket).hashCode();
    }

    public String toString() {
        return "narrow snapshot to range [" + this.startPacket + ":" + this.endPacket + "] for time [" + this.startTimestamp + ":" + this.endTimestamp + "]";
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.startTimestamp);
        writer.writeInt64(this.endTimestamp);
        writer.writeInt64(this.startPacket);
        writer.writeInt64(this.endPacket);
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public long getStartPacket() {
        return this.startPacket;
    }

    public long getEndPacket() {
        return this.endPacket;
    }

    public String getTag() {
        return TAG;
    }
}

