/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements;

import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledParameterValueRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinderElement;
import com.sap.jvm.profiling.snapshot.rootfinder.ThreadAwareRootFinderElement;
import java.io.IOException;
import java.util.Arrays;

public final class UseParameterValuesAsCalledRoots
implements CalledRootFinderElement,
ThreadAwareRootFinderElement {
    private static final String TAG = "create called root finder from parameter values";
    private static final int VERSION = 0;
    private final String specName;
    private final Parameter[] values;

    public UseParameterValuesAsCalledRoots() {
        this(null, new Parameter[0]);
    }

    public UseParameterValuesAsCalledRoots(String specName, Parameter[] values) {
        this.specName = specName;
        this.values = values;
    }

    public UseParameterValuesAsCalledRoots(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.specName = reader.readString();
        this.values = new Parameter[reader.readInt32()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Parameter.read((ResourceReader)reader);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UseParameterValuesAsCalledRoots) {
            UseParameterValuesAsCalledRoots other = (UseParameterValuesAsCalledRoots)obj;
            return this.specName.equals(other.specName) && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return 0x37673762 ^ this.specName.hashCode() ^ Arrays.hashCode(this.values);
    }

    public String toString() {
        return "create a called root finder for the method parameter specification '" + this.specName + "' and the values " + Arrays.toString(this.values);
    }

    @Override
    public CalledRootFinder createRootFinder() {
        return new CalledParameterValueRootFinder(this.specName, this.values);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeString(this.specName);
        writer.writeInt32(this.values.length);
        for (Parameter value : this.values) {
            value.write(writer);
        }
    }

    public String getTag() {
        return TAG;
    }
}

