/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements.util;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class ArrayReadStoreUtlis {
    private static final int VERSION = 0;

    public static MethodObject[] readMethods(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        MethodObject[] result = new MethodObject[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readMethodObject();
        }
        return result;
    }

    public static void writeMethods(ResourceWriter writer, MethodObject[] methods) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(methods.length);
        for (MethodObject method : methods) {
            writer.writeMethodObject(method);
        }
    }

    public static ClassObject[] readClasses(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        ClassObject[] result = new ClassObject[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readClassObject();
        }
        return result;
    }

    public static void writeClasses(ResourceWriter writer, ClassObject[] classes) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(classes.length);
        for (ClassObject clazz : classes) {
            writer.writeClassObject(clazz);
        }
    }

    public static ClassLoaderObject[] readLoaders(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        ClassLoaderObject[] result = new ClassLoaderObject[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readClassLoaderObject();
        }
        return result;
    }

    public static void writeLoaders(ResourceWriter writer, ClassLoaderObject[] loaders) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(loaders.length);
        for (ClassLoaderObject loader : loaders) {
            writer.writeClassLoaderObject(loader);
        }
    }

    public static PackageName[] readPackageNames(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        PackageName[] result = new PackageName[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readPackageName();
        }
        return result;
    }

    public static void writePackageNames(ResourceWriter writer, PackageName[] packageNames) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(packageNames.length);
        for (PackageName name : packageNames) {
            writer.writePackageName(name);
        }
    }

    public static UTF8String[] readIntenedUTFStrings(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        UTF8String[] result = new UTF8String[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readInternedUTF();
        }
        return result;
    }

    public static UTF8String[] readUTFStrings(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        UTF8String[] result = new UTF8String[reader.readInt32()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = reader.readUTF();
        }
        return result;
    }

    public static void writeUTFStrings(ResourceWriter writer, UTF8String[] strings) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(strings.length);
        for (UTF8String string : strings) {
            writer.writeUTF(string);
        }
    }
}

