/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements.util;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.util.ArrayReadStoreUtlis;
import com.sap.jvm.profiling.snapshot.elements.util.MethodFilterWithInlineBase;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public class LoadersWithInlineBase
extends MethodFilterWithInlineBase {
    private static final int VERSION = 0;
    private final ClassLoaderObject[] loaders;

    public LoadersWithInlineBase(ClassLoaderObject[] loaders, MethodFilter filter, MethodFilter inlineFilter) {
        super(filter, inlineFilter);
        this.loaders = loaders;
    }

    public LoadersWithInlineBase(ResourceReader reader) throws IOException {
        super(reader);
        reader.readVersion(0, 0);
        this.loaders = ArrayReadStoreUtlis.readLoaders(reader);
    }

    public ClassLoaderObject[] getLoaders() {
        return this.loaders;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(0);
        ArrayReadStoreUtlis.writeLoaders(writer, this.loaders);
    }
}

