/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements.util;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledMethodFilterRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CalledRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingMethodFilterRootFinder;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinder;
import java.io.IOException;

public class MethodFilterWithInlineBase {
    private static final int VERSION = 0;
    private final MethodFilter filter;
    private final MethodFilter inlineFilter;

    public MethodFilterWithInlineBase(MethodFilter filter, MethodFilter inlineFilter) {
        this.filter = filter;
        this.inlineFilter = inlineFilter;
    }

    public MethodFilterWithInlineBase(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.filter = new MethodFilter(reader);
        this.inlineFilter = reader.readBoolean() ? new MethodFilter(reader) : null;
    }

    public final MethodFilter getFilter() {
        return this.filter;
    }

    public final MethodFilter getInlineFilter() {
        return this.inlineFilter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodFilterWithInlineBase) {
            MethodFilterWithInlineBase other = (MethodFilterWithInlineBase)obj;
            if (this.inlineFilter == null) {
                if (other.inlineFilter != null) {
                    return false;
                }
                return this.filter.equals(other.filter);
            }
            if (this.inlineFilter != null && other.inlineFilter == null) {
                return false;
            }
            return this.filter.equals(other.filter) && this.inlineFilter.equals(other.inlineFilter);
        }
        return false;
    }

    public int hashCode() {
        if (this.inlineFilter == null) {
            return this.filter.hashCode();
        }
        return this.filter.hashCode() ^ this.inlineFilter.hashCode();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.filter.write(writer);
        writer.writeBoolean(this.inlineFilter != null);
        if (this.inlineFilter != null) {
            this.inlineFilter.write(writer);
        }
    }

    protected final CalledRootFinder asCalledRootFinder() {
        return new CalledMethodFilterRootFinder(this.getFilter(), this.getInlineFilter());
    }

    protected final CallingRootFinder asCallingRootFinder() {
        return new CallingMethodFilterRootFinder(this.getFilter(), this.getInlineFilter());
    }
}

