/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.elements.util;

import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.PackageNameManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.util.ArrayReadStoreUtlis;
import com.sap.jvm.profiling.snapshot.elements.util.MethodFilterWithInlineBase;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public class PackagesWithInlineBase
extends MethodFilterWithInlineBase {
    private static final int VERSION = 1;
    private final PackageName[] packages;

    public PackagesWithInlineBase(PackageName[] packages, MethodFilter filter, MethodFilter inlineFilter) {
        super(filter, inlineFilter);
        this.packages = packages;
    }

    public PackagesWithInlineBase(ResourceReader reader, boolean includeSubPackages) throws IOException {
        super(reader);
        int version = reader.readVersion(0, 1);
        if (version == 0) {
            UTF8String[] names = ArrayReadStoreUtlis.readIntenedUTFStrings(reader);
            PackageNameManager manager = reader.getSession().getPackageNameManager();
            this.packages = new PackageName[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.packages[i] = manager.getPackageName(names[i], includeSubPackages);
            }
        } else {
            this.packages = ArrayReadStoreUtlis.readPackageNames(reader);
        }
    }

    public PackageName[] getPackages() {
        return this.packages;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(1);
        ArrayReadStoreUtlis.writePackageNames(writer, this.packages);
    }
}

