/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import java.util.ArrayList;

public abstract class AbstractFilterParser {
    private final String[] keywords;
    private final String[] unaryWithExpression;
    private final String[] unaryWithParameter;
    private final String[] unaryWithoutParameter;
    private final String[] obsoleteUnaryWithoutParameter;
    private final char[] autoSepChar = new char[]{'(', ')', '!', '|', '&'};
    private String origPattern;
    private char[] condensed;
    private int condensedLength;
    private int[] origPos;
    private int[] rangePos;
    private boolean[] isComment;

    protected AbstractFilterParser() {
        String[] tmp = new String[this.getKeywordsWithExpression().length + 1];
        System.arraycopy(this.getKeywordsWithExpression(), 0, tmp, 0, tmp.length - 1);
        tmp[tmp.length - 1] = "!";
        this.unaryWithExpression = tmp;
        this.unaryWithParameter = this.getKeywordsWithParameter();
        this.unaryWithoutParameter = this.getKeywordsWithoutParameters();
        this.obsoleteUnaryWithoutParameter = this.getObsoleteKeywordsWithoutParameters();
        this.keywords = new String[this.unaryWithoutParameter.length + this.unaryWithExpression.length + this.unaryWithParameter.length];
        System.arraycopy(this.unaryWithoutParameter, 0, this.keywords, 0, this.unaryWithoutParameter.length);
        System.arraycopy(this.unaryWithExpression, 0, this.keywords, this.unaryWithoutParameter.length, this.unaryWithExpression.length);
        System.arraycopy(this.unaryWithParameter, 0, this.keywords, this.unaryWithoutParameter.length + this.unaryWithExpression.length, this.unaryWithParameter.length);
    }

    private void setPattern(String pattern) {
        if (!pattern.equals(this.origPattern)) {
            this.condense(pattern);
        }
        this.origPattern = pattern;
    }

    public final String[] getKeywords() {
        return (String[])this.keywords.clone();
    }

    public final int getCorrespondingParenthesis(String pattern, int pos) {
        this.setPattern(pattern);
        for (int i = this.condensedLength - 1; i >= 0; --i) {
            if (this.origPos[i] == pos - 1 && this.condensed[i] == ')') {
                if (this.rangePos[i] == i) {
                    return -1;
                }
                return this.origPos[this.rangePos[i]];
            }
            if (this.origPos[i] != pos || this.condensed[i] != '(') continue;
            if (this.rangePos[i] == i) {
                return -1;
            }
            return this.origPos[this.rangePos[i]] + 1;
        }
        return -1;
    }

    public final boolean isInComment(String pattern, int pos) {
        this.setPattern(pattern);
        return this.isComment[pos];
    }

    public final Token getTokenAt(String pattern, int pos) {
        int i;
        this.setPattern(pattern);
        int condensedPos = this.condensedLength - 1;
        if (pos > 0) {
            while (this.origPos[condensedPos] > pos - 1) {
                --condensedPos;
            }
        } else {
            condensedPos = 0;
        }
        String curr = "";
        String prev = "";
        String realCurr = "";
        if (condensedPos > 0) {
            char c = this.condensed[condensedPos];
            if (c == ' ') {
                if (condensedPos > 0) {
                    prev = new String(this.condensed, this.rangePos[condensedPos - 1], condensedPos - this.rangePos[condensedPos - 1]);
                }
            } else if (this.rangePos[condensedPos] > condensedPos) {
                curr = new String(this.condensed, condensedPos, 1);
                if (condensedPos > 1) {
                    prev = new String(this.condensed, this.rangePos[condensedPos - 2], condensedPos - this.rangePos[condensedPos - 2] - 1);
                }
            } else {
                curr = new String(this.condensed, this.rangePos[condensedPos], condensedPos - this.rangePos[condensedPos] + 1);
                realCurr = pattern.substring(this.origPos[this.rangePos[condensedPos]], this.origPos[condensedPos] + 1);
                if ((condensedPos = this.rangePos[condensedPos]) > 1) {
                    prev = new String(this.condensed, this.rangePos[condensedPos - 2], condensedPos - this.rangePos[condensedPos - 2] - 1);
                }
            }
        }
        if (condensedPos + 1 < this.condensedLength && this.condensed[condensedPos] == ' ' && this.origPos[condensedPos + 1] == this.origPos[condensedPos]) {
            ++condensedPos;
        }
        boolean isBinary = false;
        if (")".equals(prev)) {
            isBinary = true;
        }
        boolean isParameter = false;
        for (i = 0; i < this.unaryWithParameter.length; ++i) {
            if (!this.unaryWithParameter[i].equals(prev)) continue;
            isParameter = true;
        }
        for (i = 0; i < this.unaryWithoutParameter.length; ++i) {
            if (!this.unaryWithoutParameter[i].equals(prev)) continue;
            isBinary = true;
            break;
        }
        boolean prevIsKeyword = false;
        for (int i2 = 0; i2 < this.keywords.length; ++i2) {
            if (!prev.equals(this.keywords[i2])) continue;
            prevIsKeyword = true;
            break;
        }
        if ("&".equals(prev) || "|".equals(prev) || "(".equals(prev) || "".equals(prev)) {
            prevIsKeyword = true;
        }
        if (!prevIsKeyword) {
            isBinary = true;
        }
        ArrayList<String> possibleKeywords = new ArrayList<String>();
        if (!isBinary && !isParameter) {
            for (int i3 = 0; i3 < this.keywords.length; ++i3) {
                if (!this.keywords[i3].startsWith(curr) || this.needsInternalParameters(this.keywords[i3])) continue;
                possibleKeywords.add(this.keywords[i3]);
            }
        } else if (isBinary) {
            if (curr.length() == 0) {
                possibleKeywords.add("&&");
                possibleKeywords.add("||");
            } else if ("&".equals(curr) || "|".equals(curr)) {
                possibleKeywords.add(curr + curr);
            } else if ("&&".equals(curr) || "||".equals(curr)) {
                possibleKeywords.add(curr);
            }
        }
        return new Token(prev, curr, realCurr, possibleKeywords.toArray(new String[possibleKeywords.size()]), isParameter);
    }

    public final boolean isValid(String pattern) {
        try {
            this.parse(pattern);
        }
        catch (FilterParseException e) {
            return false;
        }
        return true;
    }

    public final Node parse(String pattern) throws FilterParseException {
        this.setPattern(pattern);
        for (int i = 0; i < this.condensedLength; ++i) {
            if (this.condensed[i] == '(' && this.rangePos[i] == i) {
                this.throwException(i, i + 1, I18n._s((String)"Missing closing ')'"));
                continue;
            }
            if (this.condensed[i] != ')' || this.rangePos[i] != i) continue;
            this.throwException(i, i + 1, I18n._s((String)"Missing opening '('"));
        }
        return this.parseImpl(0, this.condensedLength);
    }

    private void throwException(int start, int end, String message) throws FilterParseException {
        throw new FilterParseException(message, this.origPattern, this.origPos[start], this.origPos[end]);
    }

    private Node parseImpl(int start, int end) throws FilterParseException {
        int i;
        int binaryPos;
        if (start + 1 >= end) {
            this.throwException(start, end, I18n._s((String)"Empty expression"));
        }
        if ((binaryPos = this.getBinaryOpPosition('&', start, end)) == -1) {
            binaryPos = this.getBinaryOpPosition('|', start, end);
        }
        if (binaryPos != -1) {
            Node[] children = new Node[]{this.parseImpl(start, binaryPos), this.parseImpl(binaryPos + 1, end)};
            return new Node("" + this.condensed[binaryPos], null, children);
        }
        int expr1End = this.rangePos[start + 1] + 1;
        if (this.condensed[start + 1] == '(') {
            if (expr1End + 1 != end) {
                this.throwException(expr1End + 1, end - 1, I18n._s((String)"Expected '&&' or '||'"));
            }
            return this.parseImpl(start + 2, expr1End - 1);
        }
        String keyword = new String(this.condensed, start + 1, expr1End - start - 1);
        for (i = 0; i < this.unaryWithoutParameter.length; ++i) {
            if (!keyword.equals(this.unaryWithoutParameter[i])) continue;
            if (expr1End + 1 != end) {
                this.throwException(expr1End + 1, end - 1, I18n._s((String)"Unexpected parameter"));
            }
            return new Node(keyword, null, null);
        }
        for (i = 0; i < this.obsoleteUnaryWithoutParameter.length; ++i) {
            if (!keyword.equals(this.obsoleteUnaryWithoutParameter[i])) continue;
            if (expr1End + 1 != end) {
                this.throwException(expr1End + 1, end - 1, I18n._s((String)"Unexpected parameter"));
            }
            return new Node(keyword, null, null);
        }
        for (i = 0; i < this.unaryWithParameter.length; ++i) {
            int paramStart;
            String parameter;
            ErrorSpec error;
            if (!keyword.equals(this.unaryWithParameter[i])) continue;
            if (expr1End + 1 >= end) {
                this.throwException(start, expr1End, I18n._s((String)"Missing parameter"));
            }
            if ((error = this.checkParameter(keyword, parameter = new String(this.condensed, paramStart = expr1End + 1, end - paramStart - 1))) != null) {
                this.throwException(paramStart + error.getStartIndex(), paramStart + error.getEndIndex(), error.getMessage());
            }
            return new Node(keyword, parameter, null);
        }
        for (i = 0; i < this.unaryWithExpression.length; ++i) {
            if (!keyword.equals(this.unaryWithExpression[i])) continue;
            Node expr = this.parseImpl(expr1End, end);
            String message = this.checkExpression(keyword, expr);
            if (message != null) {
                this.throwException(expr1End, end, message);
            }
            return new Node(keyword, null, new Node[]{expr});
        }
        String str = new String(this.condensed, start + 1, end - start - 2);
        ErrorSpec error = this.checkPattern(str);
        if (error != null) {
            this.throwException(start + error.getStartIndex(), start + error.getEndIndex(), error.getMessage());
        }
        return new Node("pattern", str, null);
    }

    private int getBinaryOpPosition(char op, int start, int end) {
        int pos = start;
        while (pos < end) {
            char c = this.condensed[pos];
            if (c == op) {
                return pos;
            }
            pos = this.rangePos[pos] + 1;
        }
        return -1;
    }

    protected String[] getObsoleteKeywordsWithoutParameters() {
        return new String[0];
    }

    protected abstract String[] getKeywordsWithoutParameters();

    protected abstract String[] getKeywordsWithExpression();

    protected abstract String[] getKeywordsWithParameter();

    protected abstract ErrorSpec checkParameter(String var1, String var2);

    protected abstract boolean needsInternalParameters(String var1);

    protected abstract String checkExpression(String var1, Node var2);

    protected abstract ErrorSpec checkPattern(String var1);

    private void condense(String pattern) {
        char c;
        int i;
        boolean inComment = false;
        boolean inWhiteSpace = true;
        int pos = 1;
        int lastStart = -1;
        int origLen = pattern.length();
        this.isComment = new boolean[origLen + 1];
        this.condensed = new char[origLen * 3 + 1];
        this.origPos = new int[origLen * 3 + 2];
        this.rangePos = new int[origLen * 3 + 2];
        for (int i2 = 0; i2 <= origLen * 3; ++i2) {
            this.origPos[i2] = -1;
            this.rangePos[i2] = -1;
        }
        this.origPos[0] = 0;
        this.condensed[0] = 32;
        int[] stack = new int[origLen];
        int tos = 0;
        for (i = 0; i < origLen; ++i) {
            char lc;
            c = pattern.charAt(i);
            if (inComment) {
                if (c == '\r' || c == '\n') {
                    inComment = false;
                    continue;
                }
                this.isComment[i] = true;
                continue;
            }
            if (c == '/' && i < origLen - 1 && c == '/') {
                if (!inWhiteSpace) {
                    if (lastStart != -1) {
                        this.rangePos[lastStart] = pos - 1;
                        lastStart = -1;
                    }
                    this.origPos[pos] = i;
                    this.condensed[pos] = 32;
                    inWhiteSpace = true;
                    ++pos;
                }
                inComment = true;
                this.isComment[i] = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (inWhiteSpace) continue;
                if (lastStart != -1) {
                    this.rangePos[lastStart] = pos - 1;
                    lastStart = -1;
                }
                this.condensed[pos] = 32;
                this.origPos[pos] = i;
                inWhiteSpace = true;
                ++pos;
                continue;
            }
            if (c == '(') {
                if (lastStart != -1) {
                    this.rangePos[lastStart] = pos - 1;
                    lastStart = -1;
                }
                if (!inWhiteSpace) {
                    this.condensed[pos] = 32;
                    this.origPos[pos] = i;
                }
                stack[tos] = ++pos;
                ++tos;
                this.condensed[pos] = c;
                this.origPos[pos] = i;
                this.condensed[++pos] = 32;
                this.origPos[pos] = i + 1;
                inWhiteSpace = true;
                ++pos;
                continue;
            }
            if (c == ')') {
                if (lastStart != -1) {
                    this.rangePos[lastStart] = pos - 1;
                    lastStart = -1;
                }
                if (!inWhiteSpace) {
                    this.condensed[pos] = 32;
                    this.origPos[pos] = i;
                    ++pos;
                }
                if (tos > 0) {
                    this.rangePos[pos] = stack[--tos];
                    this.rangePos[stack[tos]] = pos;
                    stack[tos] = pos;
                }
                this.condensed[pos] = c;
                this.origPos[pos] = i;
                this.condensed[++pos] = 32;
                this.origPos[pos] = i + 1;
                inWhiteSpace = true;
                ++pos;
                continue;
            }
            if ((c == '&' || c == '|') && pos > 1 && c == (lc = this.condensed[pos - 2])) {
                this.origPos[pos - 1] = i + 1;
                continue;
            }
            if (this.isAutoSepChar(c)) {
                if (lastStart != -1) {
                    this.rangePos[lastStart] = pos - 1;
                    lastStart = -1;
                }
                if (!inWhiteSpace) {
                    this.condensed[pos] = 32;
                    this.origPos[pos] = i;
                    ++pos;
                }
                this.rangePos[pos] = pos;
                lastStart = -1;
                this.condensed[pos] = c;
                this.origPos[pos] = i;
                this.condensed[++pos] = 32;
                this.origPos[pos] = i + 1;
                inWhiteSpace = true;
                ++pos;
                continue;
            }
            inWhiteSpace = false;
            if (lastStart == -1) {
                lastStart = pos;
            }
            this.rangePos[pos] = lastStart;
            this.condensed[pos] = c;
            this.origPos[pos] = i;
            ++pos;
        }
        if (lastStart != -1) {
            this.rangePos[lastStart] = pos - 1;
            lastStart = -1;
        }
        if (!inWhiteSpace) {
            this.condensed[pos] = 32;
            this.origPos[pos] = origLen;
            ++pos;
        }
        for (i = 0; i <= pos; ++i) {
            if (this.rangePos[i] != -1) continue;
            this.rangePos[i] = i;
        }
        if (inComment) {
            this.isComment[origLen] = true;
        }
        i = 1;
        while (i < pos) {
            c = this.condensed[i];
            if (c == '(' || c == ')' || c == ' ' || c == '&' || c == '|') {
                i = this.rangePos[i] + 2;
                continue;
            }
            String token = new String(this.condensed, i, this.rangePos[i] - i + 1);
            boolean isKeyword = false;
            for (int j = 0; j < this.keywords.length; ++j) {
                if (!this.keywords[j].equals(token)) continue;
                i = this.rangePos[i] + 2;
                isKeyword = true;
                break;
            }
            if (isKeyword) continue;
            if (this.rangePos[i] + 2 < pos && this.condensed[this.rangePos[i] + 2] == '(') {
                int end = this.rangePos[this.rangePos[i] + 2];
                if (end == this.rangePos[i] + 2) {
                    end = pos - 1;
                }
                for (int j = i; j <= end; ++j) {
                    this.rangePos[j] = i;
                }
                this.rangePos[i] = end;
                i = end + 2;
                continue;
            }
            i = this.rangePos[i] + 2;
        }
        this.condensedLength = pos;
        this.origPos[pos] = origLen;
    }

    private boolean isAutoSepChar(char c) {
        for (int i = 0; i < this.autoSepChar.length; ++i) {
            if (this.autoSepChar[i] != c) continue;
            return true;
        }
        return false;
    }

    protected static final class ErrorSpec {
        private final int startIndex;
        private final int endIndex;
        private final String message;

        public ErrorSpec(int startIndex, int endIndex, String message) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.message = message;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static final class Token {
        private final String prev;
        private final String curr;
        private final String realCurr;
        private final String[] possibleKeywords;
        private final boolean isParameter;

        private Token(String prev, String curr, String realCurr, String[] possibleKeywords, boolean isParameter) {
            this.prev = prev;
            this.curr = curr;
            this.realCurr = realCurr;
            this.possibleKeywords = possibleKeywords;
            this.isParameter = isParameter;
        }

        public boolean isParameter() {
            return this.isParameter;
        }

        public String[] getPossibleKeywords() {
            return this.possibleKeywords;
        }

        public String getString() {
            return this.curr;
        }

        public String getRealString() {
            return this.realCurr;
        }

        public String getKeyword() {
            return this.prev;
        }
    }

    public static final class Node {
        private final String keyword;
        private final String param;
        private final Node[] children;

        private Node(String keyword, String param, Node[] children) {
            this.keyword = keyword;
            this.param = param;
            this.children = children;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getParameter() {
            return this.param;
        }

        public int getNrOfChildren() {
            if (this.children != null) {
                return this.children.length;
            }
            return 0;
        }

        public Node getChild(int index) {
            return this.children[index];
        }
    }
}

