/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackIterator;
import java.io.IOException;

public final class AllocationAreaFilter {
    private final boolean matchHeapAllocations;
    private final boolean matchStackAllocations;

    public AllocationAreaFilter(boolean matchHeapAllocations, boolean matchStackAllocations) {
        this.matchHeapAllocations = matchHeapAllocations;
        this.matchStackAllocations = matchStackAllocations;
    }

    public AllocationAreaFilter(ResourceReader reader) throws IOException {
        this.matchHeapAllocations = reader.readBoolean();
        this.matchStackAllocations = reader.readBoolean();
    }

    public boolean matches(AllocationEvent event) {
        return this.matchHeapAllocations == event.isHeapAllocation() && this.matchStackAllocations == event.isStackAllocation();
    }

    public boolean matches(ClassAndStackIterator iter) {
        return this.matchHeapAllocations == iter.isHeapAllocation() && this.matchStackAllocations == iter.isStackAllocation();
    }

    public boolean matchesHeapAllocations() {
        return this.matchHeapAllocations;
    }

    public boolean matchesStackAllocations() {
        return this.matchStackAllocations;
    }

    public AllocationAreaFilter narrow(AllocationAreaFilter other) {
        return new AllocationAreaFilter(this.matchHeapAllocations && other.matchHeapAllocations, this.matchStackAllocations && other.matchStackAllocations);
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.matchHeapAllocations);
        writer.writeBoolean(this.matchStackAllocations);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocationAreaFilter) {
            AllocationAreaFilter other = (AllocationAreaFilter)obj;
            return this.matchHeapAllocations == other.matchHeapAllocations && this.matchStackAllocations == other.matchStackAllocations;
        }
        return false;
    }

    public int hashCode() {
        return (this.matchHeapAllocations ? 1 : 0) | (this.matchStackAllocations ? 2 : 0);
    }

    public String toString() {
        String suffix = this.matchHeapAllocations && this.matchStackAllocations ? "heap and stack allocations" : (this.matchHeapAllocations ? "heap allocations" : (this.matchStackAllocations ? "stack allocations" : "no allocations"));
        return "allocation area filter matching " + suffix;
    }
}

