/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilterImpl;
import com.sap.jvm.profiling.snapshot.filter.ClassFilterParser;
import com.sap.jvm.profiling.snapshot.filter.FilterCache;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.FilterPrettyPrinter;
import java.io.IOException;

public final class ClassFilter
implements SessionAssociated {
    private final ClassFilterImpl filter;
    private final String name;
    private final int hashCode;

    public ClassFilter(ProfilingSession session, String name, String pattern) throws FilterParseException {
        assert (name != null);
        assert (session != null);
        this.filter = FilterCache.intern(new ClassFilterImpl(session, pattern));
        this.hashCode = this.filter.hashCode();
        this.name = name;
    }

    public ClassFilter(ResourceReader reader) throws IOException {
        this.filter = FilterCache.intern(new ClassFilterImpl(reader));
        this.hashCode = this.filter.hashCode();
        this.name = reader.readString();
    }

    private ClassFilter(ClassFilterImpl filter, String name) {
        assert (name != null);
        this.filter = FilterCache.intern(filter);
        this.hashCode = filter.hashCode();
        this.name = name;
    }

    public static ClassFilter createForClasses(ProfilingSession session, String name, ClassObject[] classes) {
        return new ClassFilter(new ClassFilterImpl(session, classes), name);
    }

    public static ClassFilter createForLoaders(ProfilingSession session, String name, ClassLoaderObject[] loaders) {
        return new ClassFilter(new ClassFilterImpl(session, loaders), name);
    }

    public static ClassFilter createForPackages(ProfilingSession session, String name, PackageName[] packages) {
        return new ClassFilter(new ClassFilterImpl(session, packages), name);
    }

    public static ClassFilter createForPackages(ProfilingSession session, String name, UTF8String[] packages) {
        return new ClassFilter(new ClassFilterImpl(session, packages, false), name);
    }

    public static ClassFilter createForSubPackages(ProfilingSession session, String name, UTF8String[] packages) {
        return new ClassFilter(new ClassFilterImpl(session, packages, true), name);
    }

    public static ClassFilter createNarrow(String name, ClassFilter[] filters, boolean reuseFilter) {
        return new ClassFilter(new ClassFilterImpl(filters, reuseFilter, true), name);
    }

    public static ClassFilter createWide(String name, ClassFilter[] filters, boolean reuseFilter) {
        return new ClassFilter(new ClassFilterImpl(filters, reuseFilter, false), name);
    }

    public static ClassFilter createAny(ProfilingSession session, String name) {
        return new ClassFilter(new ClassFilterImpl(session), name);
    }

    public static FilterParseException getParseException(String pattern) {
        try {
            new ClassFilterParser().parse(pattern);
            return null;
        }
        catch (FilterParseException e) {
            return e;
        }
    }

    public ClassFilter narrow(String newName, ClassFilter other, boolean reuseFilter) {
        return this.narrow(newName, new ClassFilter[]{other}, reuseFilter);
    }

    public ClassFilter narrow(String newName, ClassFilter[] others, boolean reuseFilter) {
        ClassFilter[] filters = new ClassFilter[others.length + 1];
        System.arraycopy(others, 0, filters, 1, others.length);
        filters[0] = this;
        return new ClassFilter(new ClassFilterImpl(filters, reuseFilter, true), newName);
    }

    public ClassFilter widen(String newName, ClassFilter other, boolean reuseFilter) {
        return this.widen(newName, new ClassFilter[]{other}, reuseFilter);
    }

    public ClassFilter widen(String newName, ClassFilter[] others, boolean reuseFilter) {
        ClassFilter[] filters = new ClassFilter[others.length + 1];
        System.arraycopy(others, 0, filters, 1, others.length);
        filters[0] = this;
        return new ClassFilter(new ClassFilterImpl(filters, reuseFilter, false), newName);
    }

    public ClassFilter negate(String newName) {
        return new ClassFilter(this.filter.negate(), newName);
    }

    public boolean matches(ClassObject clazz) {
        return this.filter.matches(clazz);
    }

    public String getName() {
        return this.name;
    }

    public String asString() {
        return this.filter.asString();
    }

    public void write(ResourceWriter writer) throws IOException {
        this.filter.write(writer);
        writer.writeString(this.name);
    }

    public static void prettyPrint(FilterPrettyPrinter printer, String pattern) {
        ClassFilterImpl.prettyPrint(printer, pattern);
    }

    ClassFilterImpl getImpl() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFilter) {
            ClassFilter other = (ClassFilter)obj;
            assert (this.filter.equals((Object)other.filter) == (this.filter == other.filter));
            return this.filter == ((ClassFilter)obj).filter;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    public ProfilingSession getSession() {
        return this.filter.getSession();
    }
}

