/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.ArrayClassObject;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.PackageNameManager;
import com.sap.jvm.profiling.core.type.ProtectionType;
import com.sap.jvm.profiling.core.type.StringManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.util.ArrayReadStoreUtlis;
import com.sap.jvm.profiling.snapshot.filter.AbstractFilterParser;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilterParser;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.FilterPrettyPrinter;
import com.sap.jvm.profiling.util.AbstractBooleanByIndexCache;
import com.sap.jvm.profiling.util.Glob;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public final class ClassFilterImpl
extends AbstractBooleanByIndexCache
implements SessionAssociated {
    private static final int VERSION = 0;
    private static final int AND_FILTER_NODE = 0;
    private static final int EXTENDS_FILTER_NODE = 1;
    private static final int FULL_CLASS_NAME_FILTER_NODE = 2;
    private static final int GLOB_CLASS_NAME_FILTER_NODE = 3;
    private static final int HAS_FINALIZER_FILTER_NODE = 4;
    private static final int IMPLEMENTS_FILTER_NODE = 5;
    private static final int IN_PACKAGE_FILTER_NODE = 6;
    private static final int INSTANCE_OF_FILTER_NODE = 7;
    private static final int IS_ARRAY_FILTER_NODE = 8;
    private static final int IS_INTERNAL_FILTER_NODE = 9;
    private static final int LOADER_CLASS_FILTER_NODE = 10;
    private static final int LOADER_NAME_FILTER_NODE = 11;
    private static final int MULTI_CLASS_FILTER_NODE = 12;
    private static final int MULTI_CLASS_LOADER_FILTER_NODE = 13;
    private static final int MULTI_FILTER_NODE = 14;
    private static final int MULTI_PACKAGE_FILTER_NODE = 15;
    private static final int MULTI_ROOT_NODE = 16;
    private static final int MULTI_SUB_PACKAGE_FILTER_NODE = 17;
    private static final int NARROWING_MULTI_FILTER_NODE = 18;
    private static final int NARROWING_MULTI_ROOT_NODE = 19;
    private static final int NOT_FILTER_NODE = 20;
    private static final int OR_FILTER_NODE = 21;
    private static final int IS_PUBLIC_FILTER_NODE = 22;
    private static final int IS_PRIVATE_FILTER_NODE = 23;
    private static final int IS_PROTECTED_FILTER_NODE = 24;
    private static final int IS_PACKAGE_PRIVATE_FILTER_NODE = 25;
    private static final int IS_ABSTRACT_FILTER_NODE = 26;
    private static final int IS_FINAL_FILTER_NODE = 27;
    private static final int IS_SYNTHETIC_FILTER_NODE = 29;
    private static final int IS_STATIC_FILTER_NODE = 30;
    private static final int IS_ANNOTATION_FILTER_NODE = 31;
    private static final int IS_ENUM_FILTER_NODE = 32;
    private static final int IS_INTERFACE_FILTER_NODE = 33;
    private static final int MULTI_PACKAGE_NAME_FILTER_NODE = 34;
    private static final int IN_SUB_PACKAGE_FILTER_NODE = 35;
    private static final int ANY_FILTER_NODE = 36;
    private static final int LOADER_ID_FILTER_NODE = 37;
    private final FilterNode root;
    private final ProfilingSession session;

    private ClassFilterImpl(FilterNode root, ProfilingSession session) {
        this.root = root;
        this.session = session;
    }

    ClassFilterImpl(ProfilingSession session) {
        this.session = session;
        this.root = new AnyFilterNode();
    }

    ClassFilterImpl(ProfilingSession session, String pattern) throws FilterParseException {
        this.session = session;
        ClassFilterParser parser = new ClassFilterParser();
        AbstractFilterParser.Node node = parser.parse(pattern);
        this.root = session != null ? ClassFilterImpl.convertTree(node, session) : null;
    }

    public ClassFilterImpl(ProfilingSession session, ClassObject[] classes) {
        this.session = session;
        this.root = new MultiClassFilterNode(classes);
    }

    public ClassFilterImpl(ProfilingSession session, ClassLoaderObject[] loaders) {
        this.session = session;
        this.root = new MultiClassLoaderFilterNode(loaders);
    }

    public ClassFilterImpl(ProfilingSession session, PackageName[] packages) {
        this.session = session;
        this.root = new MultiPackageNameFilterNode(packages);
    }

    public ClassFilterImpl(ProfilingSession session, UTF8String[] packages, boolean includeSubPackages) {
        this.session = session;
        this.root = includeSubPackages ? new MultiSubPackageFilterNode(packages) : new MultiPackageFilterNode(packages);
    }

    ClassFilterImpl(ClassFilter[] filters, boolean reuseFilters, boolean narrowing) {
        this.session = filters[0].getImpl().session;
        this.root = narrowing ? (reuseFilters ? new NarrowingMultiFilterNode(filters) : new NarrowingMultiRootNode(filters)) : (reuseFilters ? new MultiFilterNode(filters) : new MultiRootNode(filters));
    }

    ClassFilterImpl(ResourceReader reader) throws IOException {
        this.session = reader.getSession();
        reader.readVersion(0, 0);
        this.root = ClassFilterImpl.readFilterNode(reader);
    }

    static void prettyPrint(FilterPrettyPrinter printer, String pattern) {
        ClassFilterParser parser = new ClassFilterParser();
        try {
            ClassFilterImpl.convertTree(parser.parse(pattern), null).prettyPrint(printer);
        }
        catch (FilterParseException e) {
            Trace.warn((Throwable)e, () -> "Could not parse filter '" + pattern + "'");
        }
    }

    public ProfilingSession getSession() {
        return this.session;
    }

    private static FilterNode readFilterNode(ResourceReader reader) throws IOException {
        int tag = reader.readInt32();
        switch (tag) {
            case 0: {
                return new AndFilterNode(reader);
            }
            case 1: {
                return new ExtendsFilterNode(reader);
            }
            case 2: {
                return new FullClassNameFilterNode(reader);
            }
            case 3: {
                return new GlobClassNameFilterNode(reader);
            }
            case 4: {
                return new HasFinalizerFilterNode();
            }
            case 5: {
                return new ImplementsFilterNode(reader);
            }
            case 6: {
                return new InPackageFilterNode(reader);
            }
            case 7: {
                return new InstanceofFilterNode(reader);
            }
            case 8: {
                return new IsArrayFilterNode();
            }
            case 9: {
                return new IsInternalFilterNode();
            }
            case 10: {
                return new LoaderClassFilterNode(reader);
            }
            case 11: {
                return new LoaderNameFilterNode(reader);
            }
            case 12: {
                return new MultiClassFilterNode(reader);
            }
            case 13: {
                return new MultiClassLoaderFilterNode(reader);
            }
            case 14: {
                return new MultiFilterNode(reader);
            }
            case 15: {
                return new MultiPackageFilterNode(reader);
            }
            case 16: {
                return new MultiRootNode(reader);
            }
            case 17: {
                return new MultiSubPackageFilterNode(reader);
            }
            case 18: {
                return new NarrowingMultiFilterNode(reader);
            }
            case 19: {
                return new NarrowingMultiRootNode(reader);
            }
            case 20: {
                return new NotFilterNode(reader);
            }
            case 21: {
                return new OrFilterNode(reader);
            }
            case 22: {
                return new IsPublicFilterNode();
            }
            case 23: {
                return new IsPrivateFilterNode();
            }
            case 24: {
                return new IsProtectedFilterNode();
            }
            case 25: {
                return new IsPackagePrivateFilterNode();
            }
            case 26: {
                return new IsAbstractFilterNode();
            }
            case 27: {
                return new IsFinalFilterNode();
            }
            case 29: {
                return new IsSyntheticFilterNode();
            }
            case 30: {
                return new IsStaticFilterNode();
            }
            case 31: {
                return new IsAnnotationFilterNode();
            }
            case 32: {
                return new IsEnumFilterNode();
            }
            case 33: {
                return new IsInterfaceFilterNode();
            }
            case 34: {
                return new MultiPackageNameFilterNode(reader);
            }
            case 35: {
                return new InSubPackageFilterNode(reader);
            }
            case 36: {
                return new AnyFilterNode();
            }
            case 37: {
                return new LoaderIdFilterNode(reader);
            }
        }
        throw new IOException("Unknown tag " + tag);
    }

    public int hashCode() {
        return this.root.getNodeHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFilterImpl) {
            ClassFilterImpl other = (ClassFilterImpl)((Object)obj);
            if (this.session != other.session) {
                return false;
            }
            return this.root.isNodeEqual(other.root);
        }
        return false;
    }

    public String toString() {
        return this.asString();
    }

    String asString() {
        return this.root.asString();
    }

    ClassFilterImpl negate() {
        return new ClassFilterImpl(new NotFilterNode(this.root), this.session);
    }

    protected boolean getBooleanImpl(int index) {
        return this.root.matches(this.session.getClassObject(index));
    }

    boolean matches(ClassObject clazz) {
        return this.getBoolean(clazz.getIndex());
    }

    private static FilterNode convertTree(AbstractFilterParser.Node node, ProfilingSession session) {
        String keyword = node.getKeyword();
        if ("&".equals(keyword)) {
            return new AndFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session), ClassFilterImpl.convertTree(node.getChild(1), session));
        }
        if ("|".equals(keyword)) {
            return new OrFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session), ClassFilterImpl.convertTree(node.getChild(1), session));
        }
        if ("!".equals(keyword)) {
            return new NotFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session));
        }
        if ("instanceof".equals(keyword)) {
            return new InstanceofFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session));
        }
        if ("extends".equals(keyword)) {
            return new ExtendsFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session));
        }
        if ("implements".equals(keyword)) {
            return new ImplementsFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session));
        }
        if ("loaderclass".equals(keyword)) {
            return new LoaderClassFilterNode(ClassFilterImpl.convertTree(node.getChild(0), session));
        }
        if ("loaderid".equals(keyword)) {
            return new LoaderIdFilterNode(Long.parseLong(node.getParameter()));
        }
        if ("loadername".equals(keyword)) {
            return new LoaderNameFilterNode(node.getParameter());
        }
        if ("package".equals(keyword)) {
            return new InPackageFilterNode(node.getParameter());
        }
        if ("subpackage".equals(keyword)) {
            PackageName name;
            if (session == null) {
                return new InSubPackageFilterNode(null, node.getParameter());
            }
            PackageNameManager pkgManager = session.getPackageNameManager();
            if ("<default>".equals(node.getParameter())) {
                name = pkgManager.getDefaultPackageName();
            } else {
                StringManager stringManager = session.getStringManager();
                UTF8String rawName = stringManager.intern(node.getParameter());
                name = pkgManager.getPackageName(rawName, true);
            }
            return new InSubPackageFilterNode(name, node.getParameter());
        }
        if ("isarray".equals(keyword) || "is_array".equals(keyword)) {
            return new IsArrayFilterNode();
        }
        if ("hasfinalizer".equals(keyword) || "has_finalizer".equals(keyword)) {
            return new HasFinalizerFilterNode();
        }
        if ("isinternal".equals(keyword) || "is_internal".equals(keyword)) {
            return new IsInternalFilterNode();
        }
        if ("is_public".equals(keyword)) {
            return new IsPublicFilterNode();
        }
        if ("is_private".equals(keyword)) {
            return new IsPrivateFilterNode();
        }
        if ("is_protected".equals(keyword)) {
            return new IsProtectedFilterNode();
        }
        if ("is_package_private".equals(keyword)) {
            return new IsPackagePrivateFilterNode();
        }
        if ("is_abstract".equals(keyword)) {
            return new IsAbstractFilterNode();
        }
        if ("is_final".equals(keyword)) {
            return new IsFinalFilterNode();
        }
        if ("is_synthetic".equals(keyword)) {
            return new IsSyntheticFilterNode();
        }
        if ("is_static".equals(keyword)) {
            return new IsStaticFilterNode();
        }
        if ("is_annotation".equals(keyword)) {
            return new IsAnnotationFilterNode();
        }
        if ("is_enum".equals(keyword)) {
            return new IsEnumFilterNode();
        }
        if ("is_interface".equals(keyword)) {
            return new IsInterfaceFilterNode();
        }
        if ("pattern".equals(keyword)) {
            String pattern = node.getParameter();
            if (!pattern.contains("?") && !pattern.contains("*")) {
                return new FullClassNameFilterNode(session, pattern);
            }
            return new GlobClassNameFilterNode(pattern);
        }
        assert (false);
        return null;
    }

    void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.root.write(writer);
    }

    private static final class AnyFilterNode
    implements FilterNode {
        private AnyFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return true;
        }

        @Override
        public String asString() {
            return "*";
        }

        @Override
        public int getNodeHashCode() {
            return AnyFilterNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof AnyFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(36);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsInterfaceFilterNode
    implements FilterNode {
        private IsInterfaceFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isInterface();
        }

        @Override
        public String asString() {
            return "is_interface";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583972;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsInterfaceFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(33);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsAnnotationFilterNode
    implements FilterNode {
        private IsAnnotationFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isAnnotation();
        }

        @Override
        public String asString() {
            return "is_annotation";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583973;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsAnnotationFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(31);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsEnumFilterNode
    implements FilterNode {
        private IsEnumFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isEnum();
        }

        @Override
        public String asString() {
            return "is_enum";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583974;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsEnumFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(32);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsStaticFilterNode
    implements FilterNode {
        private IsStaticFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isStatic();
        }

        @Override
        public String asString() {
            return "is_static";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583975;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsStaticFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(30);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsSyntheticFilterNode
    implements FilterNode {
        private IsSyntheticFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isSynthetic();
        }

        @Override
        public String asString() {
            return "is_synthetic";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583976;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsSyntheticFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(29);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsFinalFilterNode
    implements FilterNode {
        private IsFinalFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isFinal();
        }

        @Override
        public String asString() {
            return "is_final";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583984;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsFinalFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(27);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsAbstractFilterNode
    implements FilterNode {
        private IsAbstractFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                return false;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).isAbstract();
        }

        @Override
        public String asString() {
            return "is_abstract";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583985;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsAbstractFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(26);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsPackagePrivateFilterNode
    implements FilterNode {
        private IsPackagePrivateFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                ClassObject base = ((ArrayClassObject)clazz).getBaseClass();
                if (base.isPrimitive()) {
                    return false;
                }
                if (base.isInternalClass()) {
                    return false;
                }
                return ((NonArrayClassObject)base).getProtection() == ProtectionType.IS_PACKAGE_PRIVATE;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).getProtection() == ProtectionType.IS_PACKAGE_PRIVATE;
        }

        @Override
        public String asString() {
            return "is_package_private";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583985;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPackagePrivateFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(25);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsProtectedFilterNode
    implements FilterNode {
        private IsProtectedFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                ClassObject base = ((ArrayClassObject)clazz).getBaseClass();
                if (base.isPrimitive()) {
                    return false;
                }
                if (base.isInternalClass()) {
                    return false;
                }
                return ((NonArrayClassObject)base).getProtection() == ProtectionType.IS_PROTECTED;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).getProtection() == ProtectionType.IS_PROTECTED;
        }

        @Override
        public String asString() {
            return "is_protected";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583986;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsProtectedFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(24);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsPrivateFilterNode
    implements FilterNode {
        private IsPrivateFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                ClassObject base = ((ArrayClassObject)clazz).getBaseClass();
                if (base.isPrimitive()) {
                    return false;
                }
                if (base.isInternalClass()) {
                    return true;
                }
                return ((NonArrayClassObject)base).getProtection() == ProtectionType.IS_PRIVATE;
            }
            if (clazz.isPrimitive()) {
                return false;
            }
            if (clazz.isInternalClass()) {
                return true;
            }
            return ((NonArrayClassObject)clazz).getProtection() == ProtectionType.IS_PRIVATE;
        }

        @Override
        public String asString() {
            return "is_private";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583987;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPrivateFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(23);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsPublicFilterNode
    implements FilterNode {
        private IsPublicFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz.isArrayClass()) {
                ClassObject base = ((ArrayClassObject)clazz).getBaseClass();
                if (base.isPrimitive()) {
                    return true;
                }
                if (base.isInternalClass()) {
                    return false;
                }
                return ((NonArrayClassObject)base).getProtection() == ProtectionType.IS_PUBLIC;
            }
            if (clazz.isPrimitive()) {
                return true;
            }
            if (clazz.isInternalClass()) {
                return false;
            }
            return ((NonArrayClassObject)clazz).getProtection() == ProtectionType.IS_PUBLIC;
        }

        @Override
        public String asString() {
            return "is_public";
        }

        @Override
        public int getNodeHashCode() {
            return 1988583988;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPublicFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(22);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class NarrowingMultiFilterNode
    implements FilterNode {
        private final ClassFilterImpl[] filters;

        public NarrowingMultiFilterNode(ClassFilter[] filters) {
            this.filters = new ClassFilterImpl[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.filters[i] = filters[i].getImpl();
            }
        }

        public NarrowingMultiFilterNode(ResourceReader reader) throws IOException {
            int nrOfFilters = reader.readInt32();
            this.filters = new ClassFilterImpl[nrOfFilters];
            for (int i = 0; i < nrOfFilters; ++i) {
                this.filters[i] = new ClassFilterImpl(reader);
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            for (ClassFilterImpl filter : this.filters) {
                if (filter.matches(clazz)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.filters.length; ++i) {
                if (i != 0) {
                    result.append(" & ");
                }
                result.append("(");
                result.append(this.filters[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return NarrowingMultiFilterNode.class.hashCode() ^ Arrays.hashCode((Object[])this.filters);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof NarrowingMultiFilterNode) {
                NarrowingMultiFilterNode other = (NarrowingMultiFilterNode)node;
                return Arrays.equals((Object[])this.filters, (Object[])other.filters);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(18);
            writer.writeInt32(this.filters.length);
            for (ClassFilterImpl filter : this.filters) {
                filter.write(writer);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class NarrowingMultiRootNode
    implements FilterNode {
        private final FilterNode[] roots;

        public NarrowingMultiRootNode(ClassFilter[] filters) {
            this.roots = new FilterNode[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.roots[i] = filters[i].getImpl().root;
            }
        }

        public NarrowingMultiRootNode(ResourceReader reader) throws IOException {
            int nrOfRoots = reader.readInt32();
            this.roots = new FilterNode[nrOfRoots];
            for (int i = 0; i < nrOfRoots; ++i) {
                this.roots[i] = ClassFilterImpl.readFilterNode(reader);
            }
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.roots.length; ++i) {
                if (i != 0) {
                    result.append(" & ");
                }
                result.append("(");
                result.append(this.roots[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public boolean matches(ClassObject clazz) {
            for (FilterNode node : this.roots) {
                if (node.matches(clazz)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getNodeHashCode() {
            int hashCode = 0;
            for (FilterNode node : this.roots) {
                hashCode ^= node.getNodeHashCode();
            }
            return hashCode ^ NarrowingMultiRootNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof NarrowingMultiRootNode) {
                NarrowingMultiRootNode other = (NarrowingMultiRootNode)node;
                if (this.roots.length != other.roots.length) {
                    return false;
                }
                for (int i = 0; i < this.roots.length; ++i) {
                    if (this.roots[i].isNodeEqual(other.roots[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(19);
            writer.writeInt32(this.roots.length);
            for (FilterNode node : this.roots) {
                node.write(writer);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiFilterNode
    implements FilterNode {
        private final ClassFilterImpl[] filters;

        public MultiFilterNode(ClassFilter[] filters) {
            this.filters = new ClassFilterImpl[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.filters[i] = filters[i].getImpl();
            }
        }

        public MultiFilterNode(ResourceReader reader) throws IOException {
            int nrOfFilters = reader.readInt32();
            this.filters = new ClassFilterImpl[nrOfFilters];
            for (int i = 0; i < nrOfFilters; ++i) {
                this.filters[i] = new ClassFilterImpl(reader);
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            for (ClassFilterImpl filter : this.filters) {
                if (!filter.matches(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.filters.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append("(");
                result.append(this.filters[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiFilterNode.class.hashCode() ^ Arrays.hashCode((Object[])this.filters);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiFilterNode) {
                MultiFilterNode other = (MultiFilterNode)node;
                return Arrays.equals((Object[])this.filters, (Object[])other.filters);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(14);
            writer.writeInt32(this.filters.length);
            for (ClassFilterImpl filter : this.filters) {
                filter.write(writer);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiRootNode
    implements FilterNode {
        private final FilterNode[] roots;

        public MultiRootNode(ClassFilter[] filters) {
            this.roots = new FilterNode[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.roots[i] = filters[i].getImpl().root;
            }
        }

        public MultiRootNode(ResourceReader reader) throws IOException {
            int nrOfRoots = reader.readInt32();
            this.roots = new FilterNode[nrOfRoots];
            for (int i = 0; i < nrOfRoots; ++i) {
                this.roots[i] = ClassFilterImpl.readFilterNode(reader);
            }
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.roots.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append("(");
                result.append(this.roots[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public boolean matches(ClassObject clazz) {
            for (FilterNode node : this.roots) {
                if (!node.matches(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getNodeHashCode() {
            int hashCode = 0;
            for (FilterNode node : this.roots) {
                hashCode ^= node.getNodeHashCode();
            }
            return hashCode ^ MultiRootNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiRootNode) {
                MultiRootNode other = (MultiRootNode)node;
                if (this.roots.length != other.roots.length) {
                    return false;
                }
                for (int i = 0; i < this.roots.length; ++i) {
                    if (this.roots[i].isNodeEqual(other.roots[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(16);
            writer.writeInt32(this.roots.length);
            for (FilterNode node : this.roots) {
                node.write(writer);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiSubPackageFilterNode
    implements FilterNode {
        private final UTF8String[] packages;

        public MultiSubPackageFilterNode(UTF8String[] packages) {
            this.packages = packages;
        }

        public MultiSubPackageFilterNode(ResourceReader reader) throws IOException {
            int nrOfPackages = reader.readInt32();
            this.packages = new UTF8String[nrOfPackages];
            for (int i = 0; i < nrOfPackages; ++i) {
                this.packages[i] = reader.readUTF();
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            UTF8String packageName = clazz.getPackageNameUTF();
            for (int i = 0; i < this.packages.length; ++i) {
                if (!packageName.startsWith(this.packages[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.packages.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append(this.packages[i]);
                result.append("*");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiSubPackageFilterNode.class.hashCode() ^ Arrays.hashCode(this.packages);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiSubPackageFilterNode) {
                MultiSubPackageFilterNode other = (MultiSubPackageFilterNode)node;
                return Arrays.equals(this.packages, other.packages);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(17);
            writer.writeInt32(this.packages.length);
            for (UTF8String pkg : this.packages) {
                writer.writeUTF(pkg);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiPackageFilterNode
    implements FilterNode {
        private final HashSet<UTF8String> packages;

        public MultiPackageFilterNode(UTF8String[] packages) {
            this.packages = new HashSet<UTF8String>(Arrays.asList(packages));
        }

        public MultiPackageFilterNode(ResourceReader reader) throws IOException {
            this.packages = new HashSet();
            int nrOfPackages = reader.readInt32();
            for (int i = 0; i < nrOfPackages; ++i) {
                this.packages.add(reader.readUTF());
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.packages.contains(clazz.getPackageNameUTF());
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            String[] packageArray = this.packages.toArray(new String[this.packages.size()]);
            for (int i = 0; i < packageArray.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append("package ");
                result.append(packageArray[i]);
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiPackageFilterNode.class.hashCode() ^ this.packages.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiPackageFilterNode) {
                MultiPackageFilterNode other = (MultiPackageFilterNode)node;
                return this.packages.equals(other.packages);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(15);
            writer.writeInt32(this.packages.size());
            for (UTF8String pkg : this.packages) {
                writer.writeUTF(pkg);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiPackageNameFilterNode
    implements FilterNode {
        private final HashSet<PackageName> plainPackages;
        private final PackageName[] subPackages;

        public MultiPackageNameFilterNode(PackageName[] packages) {
            ArrayList<PackageName> subPackagesList = new ArrayList<PackageName>();
            this.plainPackages = new HashSet();
            for (PackageName name : packages) {
                if (name.includesSubPackages()) {
                    subPackagesList.add(name);
                    continue;
                }
                this.plainPackages.add(name);
            }
            this.subPackages = subPackagesList.toArray(new PackageName[subPackagesList.size()]);
        }

        public MultiPackageNameFilterNode(ResourceReader reader) throws IOException {
            this(ArrayReadStoreUtlis.readPackageNames(reader));
        }

        @Override
        public boolean matches(ClassObject clazz) {
            assert (!clazz.getPackage().includesSubPackages());
            PackageName clazzPackageName = clazz.getPackage();
            if (this.plainPackages.contains(clazzPackageName)) {
                return true;
            }
            for (PackageName name : this.subPackages) {
                if (!clazzPackageName.matches(name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            boolean needsOr = false;
            for (PackageName name : this.plainPackages) {
                if (needsOr) {
                    result.append(" | ");
                }
                result.append("package \"");
                result.append(name.toString());
                result.append("\"");
                needsOr = true;
            }
            for (PackageName name : this.subPackages) {
                if (needsOr) {
                    result.append(" | ");
                }
                result.append("subpackage \"");
                result.append(name.toString());
                result.append("\"");
                needsOr = true;
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiPackageNameFilterNode.class.hashCode() ^ this.plainPackages.hashCode() ^ Arrays.hashCode(this.subPackages);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiPackageNameFilterNode) {
                MultiPackageNameFilterNode other = (MultiPackageNameFilterNode)node;
                return this.plainPackages.equals(other.plainPackages) && Arrays.equals(this.subPackages, other.subPackages);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(34);
            ArrayList<PackageName> packages = new ArrayList<PackageName>();
            packages.addAll(this.plainPackages);
            packages.addAll(Arrays.asList(this.subPackages));
            ArrayReadStoreUtlis.writePackageNames(writer, packages.toArray(new PackageName[0]));
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class MultiClassLoaderFilterNode
    implements FilterNode {
        private final HashSet<ClassLoaderObject> loaders;

        public MultiClassLoaderFilterNode(ClassLoaderObject[] loaders) {
            this.loaders = new HashSet<ClassLoaderObject>(Arrays.asList(loaders));
        }

        public MultiClassLoaderFilterNode(ResourceReader reader) throws IOException {
            this.loaders = new HashSet();
            int nrOfClasses = reader.readInt32();
            for (int i = 0; i < nrOfClasses; ++i) {
                this.loaders.add(reader.readClassLoaderObject());
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.loaders.contains(clazz.getClassLoader());
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            ClassLoaderObject[] loaderArray = this.loaders.toArray(new ClassLoaderObject[this.loaders.size()]);
            for (int i = 0; i < loaderArray.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append(loaderArray[i].toString());
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiClassLoaderFilterNode.class.hashCode() ^ this.loaders.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiClassLoaderFilterNode) {
                MultiClassLoaderFilterNode other = (MultiClassLoaderFilterNode)node;
                return this.loaders.equals(other.loaders);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(13);
            writer.writeInt32(this.loaders.size());
            for (ClassLoaderObject loader : this.loaders) {
                writer.writeClassLoaderObject(loader);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class MultiClassFilterNode
    implements FilterNode {
        private final HashSet<ClassObject> classes;

        public MultiClassFilterNode(ClassObject[] classes) {
            this.classes = new HashSet<ClassObject>(Arrays.asList(classes));
        }

        public MultiClassFilterNode(ResourceReader reader) throws IOException {
            this.classes = new HashSet();
            int nrOfClasses = reader.readInt32();
            for (int i = 0; i < nrOfClasses; ++i) {
                this.classes.add(reader.readClassObject());
            }
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.classes.contains(clazz);
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            ClassObject[] classArray = this.classes.toArray(new ClassObject[this.classes.size()]);
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append(classArray[i].toString());
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return MultiClassFilterNode.class.hashCode() ^ this.classes.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiClassFilterNode) {
                MultiClassFilterNode other = (MultiClassFilterNode)node;
                return this.classes.equals(other.classes);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(12);
            writer.writeInt32(this.classes.size());
            for (ClassObject clazz : this.classes) {
                writer.writeClassObject(clazz);
            }
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            assert (false);
        }
    }

    private static final class GlobClassNameFilterNode
    implements FilterNode {
        private final String pattern;
        private final Glob matcher;

        public GlobClassNameFilterNode(String pattern) {
            this.pattern = pattern;
            this.matcher = new Glob(pattern);
        }

        public GlobClassNameFilterNode(ResourceReader reader) throws IOException {
            this.pattern = reader.readString();
            this.matcher = new Glob(this.pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(ClassObject clazz) {
            Glob glob = this.matcher;
            synchronized (glob) {
                return this.matcher.isFullMatch(clazz.getFullName());
            }
        }

        @Override
        public String asString() {
            return this.pattern;
        }

        @Override
        public int getNodeHashCode() {
            return GlobClassNameFilterNode.class.hashCode() ^ this.pattern.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof GlobClassNameFilterNode) {
                GlobClassNameFilterNode other = (GlobClassNameFilterNode)node;
                return this.pattern.equals(other.pattern);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(3);
            writer.writeString(this.pattern);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.pattern);
        }
    }

    private static final class FullClassNameFilterNode
    implements FilterNode {
        private final UTF8String packageNameUTF;
        private final UTF8String classNameUTF;
        private final ProfilingSession session;
        private final String origPattern;

        public FullClassNameFilterNode(ProfilingSession session, String pattern) {
            assert (!pattern.contains("?"));
            assert (!pattern.contains("*"));
            this.session = session;
            this.origPattern = pattern;
            if (session == null) {
                this.packageNameUTF = null;
                this.classNameUTF = null;
            } else {
                int lastDot = pattern.lastIndexOf(46);
                StringManager manager = session.getStringManager();
                if (lastDot >= 0) {
                    String packageName = pattern.substring(0, lastDot);
                    String className = pattern.substring(lastDot + 1);
                    this.packageNameUTF = manager.intern(packageName);
                    this.classNameUTF = manager.intern(className);
                } else {
                    this.packageNameUTF = manager.intern("");
                    this.classNameUTF = manager.intern(pattern);
                }
            }
        }

        public FullClassNameFilterNode(ResourceReader reader) throws IOException {
            this.session = reader.getSession();
            this.packageNameUTF = reader.readInternedUTF();
            this.classNameUTF = reader.readInternedUTF();
            this.origPattern = null;
        }

        @Override
        public boolean matches(ClassObject clazz) {
            assert (clazz.getSession() == this.session);
            return clazz.getPackageNameUTF().equals(this.packageNameUTF) && clazz.getNameUTF().equals(this.classNameUTF);
        }

        @Override
        public String asString() {
            if (this.packageNameUTF.length() == 0) {
                return this.packageNameUTF.toString();
            }
            return this.packageNameUTF + "." + this.classNameUTF;
        }

        @Override
        public int getNodeHashCode() {
            return FullClassNameFilterNode.class.hashCode() ^ this.packageNameUTF.hashCode() ^ this.classNameUTF.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof FullClassNameFilterNode) {
                FullClassNameFilterNode other = (FullClassNameFilterNode)node;
                return this.packageNameUTF.equals(other.packageNameUTF) && this.classNameUTF.equals(other.classNameUTF);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(2);
            writer.writeUTF(this.packageNameUTF);
            writer.writeUTF(this.classNameUTF);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.origPattern != null ? this.origPattern : this.toString());
        }
    }

    private static final class InSubPackageFilterNode
    implements FilterNode {
        private final PackageName name;
        private final String origName;

        public InSubPackageFilterNode(PackageName name, String origName) {
            this.name = name;
            this.origName = origName;
        }

        public InSubPackageFilterNode(ResourceReader reader) throws IOException {
            this.name = reader.readPackageName();
            this.origName = null;
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return clazz.getPackage().matches(this.name);
        }

        @Override
        public String asString() {
            return "subpackage \"" + this.name + "\"";
        }

        @Override
        public int getNodeHashCode() {
            return InSubPackageFilterNode.class.hashCode() ^ this.name.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof InSubPackageFilterNode) {
                InSubPackageFilterNode other = (InSubPackageFilterNode)node;
                return this.name.equals(other.name);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(35);
            writer.writePackageName(this.name);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("subpackage ");
            printer.quoteIfNeeded(this.origName != null ? this.origName : this.name.getName().toString());
        }
    }

    private static final class InPackageFilterNode
    implements FilterNode {
        private final String packageName;

        public InPackageFilterNode(String packageName) {
            this.packageName = "<default>".equals(packageName) ? "" : packageName;
        }

        public InPackageFilterNode(ResourceReader reader) throws IOException {
            this.packageName = reader.readString();
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return clazz.getPackageName().equals(this.packageName);
        }

        @Override
        public String asString() {
            if (this.packageName.length() == 0) {
                return "package \"\"";
            }
            return "package \"" + this.packageName + "\"";
        }

        @Override
        public int getNodeHashCode() {
            return InPackageFilterNode.class.hashCode() ^ this.packageName.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof InPackageFilterNode) {
                InPackageFilterNode other = (InPackageFilterNode)node;
                return this.packageName.equals(other.packageName);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(6);
            writer.writeString(this.packageName);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("package ");
            printer.quoteIfNeeded(this.packageName);
        }
    }

    private static final class IsInternalFilterNode
    implements FilterNode {
        private IsInternalFilterNode() {
        }

        @Override
        public String asString() {
            return "is_internal";
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return clazz.isInternalClass();
        }

        @Override
        public int getNodeHashCode() {
            return IsInternalFilterNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsInternalFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(9);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class IsArrayFilterNode
    implements FilterNode {
        private IsArrayFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return clazz.isArrayClass();
        }

        @Override
        public String asString() {
            return "is_array";
        }

        @Override
        public int getNodeHashCode() {
            return IsArrayFilterNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsArrayFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(8);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class HasFinalizerFilterNode
    implements FilterNode {
        private HasFinalizerFilterNode() {
        }

        @Override
        public boolean matches(ClassObject clazz) {
            if (clazz instanceof NonArrayClassObject) {
                NonArrayClassObject nonArrayClass = (NonArrayClassObject)clazz;
                return nonArrayClass.hasFinalizer();
            }
            return false;
        }

        @Override
        public String asString() {
            return "has_finalizer";
        }

        @Override
        public int getNodeHashCode() {
            return HasFinalizerFilterNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof HasFinalizerFilterNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(4);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print(this.asString());
        }
    }

    private static final class LoaderNameFilterNode
    implements FilterNode {
        private final String pattern;
        private final Glob matcher;

        public LoaderNameFilterNode(String pattern) {
            this.pattern = pattern;
            this.matcher = new Glob(pattern);
        }

        public LoaderNameFilterNode(ResourceReader reader) throws IOException {
            this.pattern = reader.readString();
            this.matcher = new Glob(this.pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(ClassObject clazz) {
            ClassLoaderObject loader = clazz.getClassLoader();
            String name = loader.getName();
            Glob glob = this.matcher;
            synchronized (glob) {
                return this.matcher.isFullMatch(name);
            }
        }

        @Override
        public String asString() {
            return "(loadername " + this.pattern + ")";
        }

        @Override
        public int getNodeHashCode() {
            return LoaderNameFilterNode.class.hashCode() ^ this.pattern.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof LoaderNameFilterNode) {
                return this.pattern.equals(((LoaderNameFilterNode)other).pattern);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(11);
            writer.writeString(this.pattern);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("loadername ");
            printer.quoteIfNeeded(this.pattern);
        }
    }

    private static final class LoaderIdFilterNode
    implements FilterNode {
        private final long id;

        public LoaderIdFilterNode(long id) {
            this.id = id;
        }

        public LoaderIdFilterNode(ResourceReader reader) throws IOException {
            this.id = reader.readInt64();
        }

        @Override
        public boolean matches(ClassObject clazz) {
            ClassLoaderObject loader = clazz.getClassLoader();
            return loader.getId() == this.id;
        }

        @Override
        public String asString() {
            return "(loaderid " + this.id + ")";
        }

        @Override
        public int getNodeHashCode() {
            return LoaderIdFilterNode.class.hashCode() ^ (int)(this.id >> 32) ^ (int)this.id;
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof LoaderIdFilterNode) {
                return this.id == ((LoaderIdFilterNode)other).id;
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(37);
            writer.writeInt64(this.id);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("loaderid " + this.id);
        }
    }

    private static final class LoaderClassFilterNode
    implements FilterNode {
        private final FilterNode node;

        public LoaderClassFilterNode(FilterNode node) {
            this.node = node;
        }

        public LoaderClassFilterNode(ResourceReader reader) throws IOException {
            this.node = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            ClassLoaderObject loader = clazz.getClassLoader();
            if (loader.isBootstrapClassLoader()) {
                return false;
            }
            return this.node.matches(loader.getClassObject());
        }

        @Override
        public String asString() {
            return "(loaderclass " + this.node.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return LoaderClassFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof LoaderClassFilterNode) {
                return this.node.isNodeEqual(((LoaderClassFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(10);
            this.node.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("loaderclass ");
            this.node.prettyPrint(printer);
        }
    }

    private static final class InstanceofFilterNode
    implements FilterNode {
        private final FilterNode node;

        public InstanceofFilterNode(FilterNode node) {
            this.node = node;
        }

        public InstanceofFilterNode(ResourceReader reader) throws IOException {
            this.node = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.node.matches(clazz) || ExtendsFilterNode.matches(this.node, clazz) || ImplementsFilterNode.matches(this.node, clazz);
        }

        @Override
        public String asString() {
            return "(instanceof " + this.node.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return InstanceofFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof InstanceofFilterNode) {
                return this.node.isNodeEqual(((InstanceofFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(7);
            this.node.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("instanceof ");
            this.node.prettyPrint(printer);
        }
    }

    private static final class ImplementsFilterNode
    implements FilterNode {
        private final FilterNode node;

        public ImplementsFilterNode(FilterNode node) {
            this.node = node;
        }

        public ImplementsFilterNode(ResourceReader reader) throws IOException {
            this.node = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return ImplementsFilterNode.matches(this.node, clazz);
        }

        @Override
        public String asString() {
            return "(implements " + this.node.asString() + ")";
        }

        public static boolean matches(FilterNode node, ClassObject clazz) {
            if (clazz instanceof NonArrayClassObject) {
                NonArrayClassObject nonArrayClass = (NonArrayClassObject)clazz;
                for (int i = nonArrayClass.getNrOfInterfaces() - 1; i >= 0; --i) {
                    NonArrayClassObject currInterface = nonArrayClass.getInterface(i);
                    if (node.matches((ClassObject)currInterface)) {
                        return true;
                    }
                    if (!ImplementsFilterNode.matches(node, (ClassObject)currInterface)) continue;
                    return true;
                }
                return ImplementsFilterNode.matches(node, (ClassObject)nonArrayClass.getSuperClass());
            }
            return false;
        }

        @Override
        public int getNodeHashCode() {
            return ImplementsFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof ImplementsFilterNode) {
                return this.node.isNodeEqual(((ImplementsFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(5);
            this.node.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("implements ");
            this.node.prettyPrint(printer);
        }
    }

    private static final class ExtendsFilterNode
    implements FilterNode {
        private final FilterNode node;

        public ExtendsFilterNode(FilterNode node) {
            this.node = node;
        }

        public ExtendsFilterNode(ResourceReader reader) throws IOException {
            this.node = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return ExtendsFilterNode.matches(this.node, clazz);
        }

        @Override
        public String asString() {
            return "(extends " + this.node.asString() + ")";
        }

        public static boolean matches(FilterNode node, ClassObject clazz) {
            for (NonArrayClassObject superClass = clazz.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                if (!node.matches((ClassObject)superClass)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getNodeHashCode() {
            return ExtendsFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof ExtendsFilterNode) {
                return this.node.isNodeEqual(((ExtendsFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(1);
            this.node.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("extends ");
            this.node.prettyPrint(printer);
        }
    }

    private static final class NotFilterNode
    implements FilterNode {
        private final FilterNode node;

        public NotFilterNode(FilterNode node) {
            this.node = node;
        }

        public NotFilterNode(ResourceReader reader) throws IOException {
            this.node = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return !this.node.matches(clazz);
        }

        @Override
        public String asString() {
            return "(!" + this.node.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return NotFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof NotFilterNode) {
                return this.node.isNodeEqual(((NotFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(20);
            this.node.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            printer.print("! ");
            this.node.prettyPrint(printer);
        }
    }

    private static final class OrFilterNode
    implements FilterNode {
        private final FilterNode node1;
        private final FilterNode node2;

        public OrFilterNode(FilterNode node1, FilterNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        public OrFilterNode(ResourceReader reader) throws IOException {
            this.node1 = ClassFilterImpl.readFilterNode(reader);
            this.node2 = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.node1.matches(clazz) || this.node2.matches(clazz);
        }

        @Override
        public String asString() {
            return "(" + this.node1.asString() + " || " + this.node2.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return OrFilterNode.class.hashCode() ^ this.node1.getNodeHashCode() ^ this.node2.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof OrFilterNode) {
                OrFilterNode otherNode = (OrFilterNode)node;
                return this.node1.isNodeEqual(otherNode.node1) && this.node2.isNodeEqual(otherNode.node2);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(21);
            this.node1.write(writer);
            this.node2.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            this.prettyPrintImpl(printer, true);
        }

        private void prettyPrintImpl(FilterPrettyPrinter printer, boolean group) {
            if (group) {
                printer.print("( ");
                printer.makeTab();
            }
            if (this.node1 instanceof OrFilterNode) {
                ((OrFilterNode)this.node1).prettyPrintImpl(printer, false);
            } else {
                this.node1.prettyPrint(printer);
            }
            printer.println(" |");
            if (this.node2 instanceof OrFilterNode) {
                ((OrFilterNode)this.node2).prettyPrintImpl(printer, false);
            } else {
                this.node2.prettyPrint(printer);
            }
            if (group) {
                printer.print(" )");
                printer.removeTab();
            }
        }
    }

    private static final class AndFilterNode
    implements FilterNode {
        private final FilterNode node1;
        private final FilterNode node2;

        public AndFilterNode(FilterNode node1, FilterNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        public AndFilterNode(ResourceReader reader) throws IOException {
            this.node1 = ClassFilterImpl.readFilterNode(reader);
            this.node2 = ClassFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(ClassObject clazz) {
            return this.node1.matches(clazz) && this.node2.matches(clazz);
        }

        @Override
        public String asString() {
            return "(" + this.node1.asString() + " && " + this.node2.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return AndFilterNode.class.hashCode() ^ this.node1.getNodeHashCode() ^ this.node2.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof AndFilterNode) {
                AndFilterNode otherNode = (AndFilterNode)node;
                return this.node1.isNodeEqual(otherNode.node1) && this.node2.isNodeEqual(otherNode.node2);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(0);
            this.node1.write(writer);
            this.node2.write(writer);
        }

        @Override
        public void prettyPrint(FilterPrettyPrinter printer) {
            this.prettyPrintImpl(printer, true);
        }

        private void prettyPrintImpl(FilterPrettyPrinter printer, boolean group) {
            if (group) {
                printer.print("( ");
                printer.makeTab();
            }
            if (this.node1 instanceof AndFilterNode) {
                ((AndFilterNode)this.node1).prettyPrintImpl(printer, false);
            } else {
                this.node1.prettyPrint(printer);
            }
            printer.println(" &");
            if (this.node2 instanceof AndFilterNode) {
                ((AndFilterNode)this.node2).prettyPrintImpl(printer, false);
            } else {
                this.node2.prettyPrint(printer);
            }
            if (group) {
                printer.print(" )");
                printer.removeTab();
            }
        }
    }

    private static interface FilterNode {
        public boolean matches(ClassObject var1);

        public String asString();

        public boolean isNodeEqual(FilterNode var1);

        public int getNodeHashCode();

        public void write(ResourceWriter var1) throws IOException;

        public void prettyPrint(FilterPrettyPrinter var1);
    }
}

