/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.AbstractFilterParser;

public class ClassFilterParser
extends AbstractFilterParser {
    @Override
    protected AbstractFilterParser.ErrorSpec checkParameter(String keyword, String parameter) {
        if ("<default>".equals(parameter)) {
            return null;
        }
        if ("package".equals(keyword) || "subpackage".equals(keyword)) {
            int start = 0;
            if (parameter.startsWith("<default>")) {
                start = "<default>".length();
            }
            for (int i = start; i < parameter.length(); ++i) {
                char c = parameter.charAt(i);
                if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
                return new AbstractFilterParser.ErrorSpec(i, i + 1, I18n._s((String)"Invalid character"));
            }
            return null;
        }
        if ("loaderid".equals(keyword)) {
            try {
                Long.parseLong(parameter);
            }
            catch (NumberFormatException e) {
                return new AbstractFilterParser.ErrorSpec(0, parameter.length(), I18n._s((String)"Invalid number"));
            }
        }
        return null;
    }

    @Override
    protected String checkExpression(String keyword, AbstractFilterParser.Node expression) {
        return null;
    }

    @Override
    protected AbstractFilterParser.ErrorSpec checkPattern(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '.' || c == '$' || c == '*' || c == '?' || c == '[' || c == ']' || c == '{' || c == '}' || c == '<' || c == '>' || Character.isJavaIdentifierPart(c)) continue;
            return new AbstractFilterParser.ErrorSpec(i, i + 1, I18n._s((String)"Invalid character '{0}'", (Object[])new Object[]{"" + c}));
        }
        return null;
    }

    @Override
    protected String[] getKeywordsWithExpression() {
        return new String[]{"instanceof", "extends", "implements", "loaderclass"};
    }

    @Override
    protected String[] getKeywordsWithParameter() {
        return new String[]{"package", "subpackage", "loadername", "loaderid"};
    }

    @Override
    protected String[] getKeywordsWithoutParameters() {
        return new String[]{"has_finalizer", "is_array", "is_internal", "is_public", "is_private", "is_protected", "is_package_private", "is_abstract", "is_final", "is_synthetic", "is_static", "is_annotation", "is_enum", "is_interface"};
    }

    @Override
    protected String[] getObsoleteKeywordsWithoutParameters() {
        return new String[]{"hasfinalizer", "isarray", "isinternal"};
    }

    @Override
    protected boolean needsInternalParameters(String keyword) {
        return "classlist".equals(keyword) || "packagelist".equals(keyword) || "subpackagelist".equals(keyword) || "loaderlist".equals(keyword) || "filterlist".equals(keyword);
    }
}

