/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public final class FileFilter {
    public static final String NO_FILTER = "**";
    private HashSet<UTF8String> names = new HashSet();
    private ArrayList<Long> sortedIds = new ArrayList();
    private boolean filteringIds = false;
    private boolean filteringNames = false;

    public FileFilter() {
    }

    public FileFilter(UTF8String[] filenames) {
        this();
        this.filterNames(filenames);
    }

    public boolean isFiltering() {
        return this.filteringIds || this.filteringNames;
    }

    public boolean isFilteringId() {
        return this.filteringIds;
    }

    public boolean isFilteringNames() {
        return this.filteringNames;
    }

    public String asString() {
        StringBuilder buffer = new StringBuilder();
        if (this.filteringNames) {
            this.appendFileNames(buffer);
        }
        if (this.filteringIds) {
            this.appendFileIds(buffer);
        }
        return buffer.toString();
    }

    public String[] getFileNames() {
        String[] result = new String[this.names.size()];
        int idx = 0;
        for (UTF8String name : this.names) {
            try {
                result[idx] = new String(name.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                result[idx] = "???";
            }
            ++idx;
        }
        return result;
    }

    public FileFilter copy() {
        FileFilter result = new FileFilter();
        result.names = new HashSet<UTF8String>(this.names);
        result.sortedIds = new ArrayList<Long>(this.sortedIds);
        result.filteringIds = this.filteringIds;
        result.filteringNames = this.filteringNames;
        return result;
    }

    public void narrow(FileFilter otherFilter) {
        if (!this.filteringIds) {
            this.filteringIds = otherFilter.filteringIds;
            this.sortedIds.addAll(otherFilter.sortedIds);
        } else if (otherFilter.filteringIds) {
            ArrayList<Long> tmpIds = new ArrayList<Long>();
            for (long id : this.sortedIds) {
                if (!otherFilter.contains(id)) continue;
                tmpIds.add(id);
            }
            this.sortedIds = tmpIds;
            Collections.sort(this.sortedIds);
        }
        if (!this.filteringNames) {
            this.filteringNames = otherFilter.filteringNames;
            this.names.addAll(otherFilter.names);
        } else if (otherFilter.filteringNames) {
            HashSet<UTF8String> tmpNames = new HashSet<UTF8String>();
            for (UTF8String name : this.names) {
                if (!otherFilter.names.contains(name)) continue;
                tmpNames.add(name);
            }
            this.names = tmpNames;
        }
    }

    public void remove() {
        this.filteringIds = false;
        this.filteringNames = false;
        this.names = new HashSet();
        this.sortedIds = new ArrayList();
    }

    public void filterNames(UTF8String[] fileNames) {
        this.names.clear();
        for (UTF8String name : fileNames) {
            this.names.add(name);
        }
        this.filteringNames = true;
    }

    public void filterIds(long[] fileIds) {
        this.sortedIds.clear();
        for (int i = 0; i < fileIds.length; ++i) {
            this.sortedIds.add(fileIds[i]);
        }
        Collections.sort(this.sortedIds);
        this.filteringIds = true;
    }

    public boolean applies(UTF8String name, long id) {
        if (this.filteringIds && id != -1L && !this.contains(id)) {
            return false;
        }
        return !this.filteringNames || this.names.contains(name);
    }

    private boolean contains(long fileId) {
        return Collections.binarySearch(this.sortedIds, fileId) >= 0;
    }

    public int hashCode() {
        return this.names.hashCode() ^ this.sortedIds.hashCode() + (this.filteringIds ? 3 : 5) + (this.filteringNames ? 7 : 11);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FileFilter)) {
            return false;
        }
        FileFilter tmpFilter = (FileFilter)obj;
        return this.names.equals(tmpFilter.names) && this.sortedIds.equals(tmpFilter.sortedIds) && this.filteringIds == tmpFilter.filteringIds && this.filteringNames == tmpFilter.filteringNames;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Filter file names (");
        builder.append(this.filteringNames ? "X): " : " ): ");
        builder.append(this.names.toString());
        builder.append(", file ids (");
        builder.append(this.filteringIds ? "X): " : " ): ");
        builder.append(this.sortedIds);
        return builder.toString();
    }

    private void appendFileNames(StringBuilder buffer) {
        if (this.names.isEmpty()) {
            buffer.append("matching no file name");
            return;
        }
        boolean firstEntry = false;
        for (UTF8String nextFileName : this.names) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("name=").append(UTF8Util.asString((byte[])nextFileName.getBytes()));
            firstEntry = false;
        }
    }

    private void appendFileIds(StringBuilder buffer) {
        if (this.sortedIds.isEmpty()) {
            buffer.append("matching no file id");
            return;
        }
        boolean firstEntry = false;
        for (long id : this.sortedIds) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("id=").append(id);
            firstEntry = false;
        }
    }
}

