/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.snapshot.filter.ClassFilterImpl;
import com.sap.jvm.profiling.snapshot.filter.MethodFilterImpl;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

final class FilterCache {
    private static final WeakHashMap<ProfilingSession, WeakHashMap<MethodFilterImpl, WeakReference<MethodFilterImpl>>> methodFilters = new WeakHashMap();
    private static final WeakHashMap<ProfilingSession, WeakHashMap<ClassFilterImpl, WeakReference<ClassFilterImpl>>> classFilters = new WeakHashMap();

    FilterCache() {
    }

    public static synchronized ClassFilterImpl intern(ClassFilterImpl filter) {
        ClassFilterImpl realFilter;
        WeakReference<ClassFilterImpl> internedFilter;
        ProfilingSession session = filter.getSession();
        WeakHashMap<ClassFilterImpl, WeakReference<ClassFilterImpl>> map = classFilters.get(session);
        if (map != null && (internedFilter = map.get((Object)filter)) != null && (realFilter = (ClassFilterImpl)((Object)internedFilter.get())) != null) {
            return realFilter;
        }
        if (map == null) {
            map = new WeakHashMap();
            classFilters.put(session, map);
        }
        map.put(filter, new WeakReference<ClassFilterImpl>(filter));
        return filter;
    }

    public static synchronized MethodFilterImpl intern(MethodFilterImpl filter) {
        MethodFilterImpl realFilter;
        WeakReference<MethodFilterImpl> internedFilter;
        ProfilingSession session = filter.getSession();
        WeakHashMap<MethodFilterImpl, WeakReference<MethodFilterImpl>> map = methodFilters.get(session);
        if (map != null && (internedFilter = map.get((Object)filter)) != null && (realFilter = (MethodFilterImpl)((Object)internedFilter.get())) != null) {
            return realFilter;
        }
        if (map == null) {
            map = new WeakHashMap();
            methodFilters.put(session, map);
        }
        map.put(filter, new WeakReference<MethodFilterImpl>(filter));
        return filter;
    }
}

