/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

public class FilterParseException
extends Exception {
    private static final long serialVersionUID = 1691123112517625027L;
    private final String pattern;
    private final int startIndex;
    private final int endIndex;

    public FilterParseException(String message, String pattern, int startIndex, int endIndex) {
        super(message);
        assert (startIndex <= endIndex);
        assert (pattern.length() == 0 || endIndex <= pattern.length());
        this.pattern = pattern;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getPatternWithError() {
        if (this.pattern.length() == 0) {
            return "><";
        }
        StringBuilder result = new StringBuilder(this.pattern.length() + 2);
        result.append(this.pattern.substring(0, this.startIndex));
        result.append('>');
        result.append(this.pattern.substring(this.startIndex, this.endIndex));
        result.append('<');
        result.append(this.pattern.substring(this.endIndex));
        return result.toString();
    }
}

