/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import java.util.ArrayList;

public class FilterPrettyPrinter {
    private int currIndent;
    private final StringBuilder result = new StringBuilder();
    private final ArrayList<Integer> indentations = new ArrayList();
    private int length;
    private boolean hasAddedIndent;

    public void print(String str) {
        if (!this.hasAddedIndent) {
            for (int i = 0; i < this.currIndent; ++i) {
                this.result.append(' ');
            }
            this.length = this.currIndent;
            this.hasAddedIndent = true;
        }
        this.result.append(str);
        this.length += str.length();
    }

    public void println(String str) {
        this.print(str);
        this.result.append('\n');
        this.hasAddedIndent = false;
    }

    public void quoteIfNeeded(String str) {
        this.print("\"" + str + "\"");
    }

    public void makeTab() {
        this.print("");
        this.indentations.add(this.currIndent);
        this.currIndent = this.length;
    }

    public void removeTab() {
        this.currIndent = this.indentations.remove(this.indentations.size() - 1);
    }

    public String toString() {
        return this.result.toString();
    }
}

