/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class GcEventTypeFilter {
    private Set<GcEventType> eventTypes = new HashSet<GcEventType>();
    private boolean isFiltering = false;

    public boolean isFiltering() {
        return this.isFiltering;
    }

    public String asString() {
        if (!this.isFiltering) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("Filter GC event types (");
        if (this.eventTypes.isEmpty()) {
            buffer.append("matching no event types");
        } else {
            boolean first = true;
            for (GcEventType type : this.eventTypes) {
                if (!first) {
                    buffer.append(", ");
                }
                buffer.append(type.name());
                first = false;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public GcEventTypeFilter copy() {
        GcEventTypeFilter result = new GcEventTypeFilter();
        result.eventTypes = new HashSet<GcEventType>(this.eventTypes);
        result.isFiltering = this.isFiltering;
        return result;
    }

    public void narrow(GcEventTypeFilter otherFilter) {
        if (!otherFilter.isFiltering()) {
            return;
        }
        if (!this.isFiltering) {
            this.eventTypes.addAll(otherFilter.eventTypes);
            this.isFiltering = true;
        }
        HashSet<GcEventType> tmpSet = new HashSet<GcEventType>();
        for (GcEventType type : this.eventTypes) {
            if (!otherFilter.eventTypes.contains(type)) continue;
            tmpSet.add(type);
        }
        this.eventTypes = tmpSet;
    }

    public void remove() {
        this.eventTypes.clear();
        this.isFiltering = false;
    }

    public void filterIds(Set<GcEventType> types) {
        this.eventTypes.clear();
        this.eventTypes.addAll(types);
        this.isFiltering = true;
    }

    public boolean applies(GcEventBase event) {
        if (this.isFiltering) {
            for (GcEventType type : this.eventTypes) {
                if (type != event.getGcEventType()) continue;
                return true;
            }
        }
        return false;
    }

    public Set<GcEventType> getEventTypes() {
        if (!this.isFiltering) {
            return null;
        }
        return Collections.unmodifiableSet(this.eventTypes);
    }

    public int hashCode() {
        return this.eventTypes.hashCode() + (this.isFiltering ? 3 : 5);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GcEventTypeFilter)) {
            return false;
        }
        GcEventTypeFilter tmpFilter = (GcEventTypeFilter)obj;
        return this.eventTypes.equals(tmpFilter.eventTypes) && this.isFiltering == tmpFilter.isFiltering;
    }

    public String toString() {
        if (!this.isFiltering) {
            return "Filter GC event types, not filtering";
        }
        return this.asString();
    }
}

