/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import java.util.ArrayList;
import java.util.Collections;

public final class GcFilter {
    private ArrayList<Long> sortedIds = new ArrayList();
    private boolean filteringIds = false;
    private boolean filteringPromotionFailures = false;

    public boolean isFiltering() {
        return this.filteringIds || this.filteringPromotionFailures;
    }

    public boolean isFilteringId() {
        return this.filteringIds;
    }

    public boolean isFilteringPromotionFailures() {
        return this.filteringPromotionFailures;
    }

    public String asString() {
        StringBuilder buffer = new StringBuilder();
        if (this.filteringPromotionFailures) {
            buffer.append("promotionFailures=true ");
        }
        if (this.filteringIds) {
            this.appendGcIds(buffer);
        }
        return buffer.toString();
    }

    public GcFilter copy() {
        GcFilter result = new GcFilter();
        result.sortedIds = new ArrayList<Long>(this.sortedIds);
        result.filteringIds = this.filteringIds;
        result.filteringPromotionFailures = this.filteringPromotionFailures;
        return result;
    }

    public void narrow(GcFilter otherFilter) {
        if (!this.filteringIds) {
            this.filteringIds = otherFilter.filteringIds;
            this.sortedIds.addAll(otherFilter.sortedIds);
        } else if (otherFilter.filteringIds) {
            ArrayList<Long> tmpIds = new ArrayList<Long>();
            for (long id : this.sortedIds) {
                if (!otherFilter.contains(id)) continue;
                tmpIds.add(id);
            }
            this.sortedIds = tmpIds;
            Collections.sort(this.sortedIds);
        }
        this.filteringPromotionFailures = this.filteringPromotionFailures || otherFilter.filteringPromotionFailures;
    }

    public void remove() {
        this.filteringIds = false;
        this.filteringPromotionFailures = false;
        this.sortedIds = new ArrayList();
    }

    public void filterIds(long[] gcIds) {
        this.sortedIds.clear();
        for (int i = 0; i < gcIds.length; ++i) {
            this.sortedIds.add(gcIds[i]);
        }
        Collections.sort(this.sortedIds);
        this.filteringIds = true;
    }

    public void filterPromotionFailures() {
        this.filteringPromotionFailures = true;
    }

    public boolean applies(GcStatistic gcInfo) {
        if (this.filteringIds && !this.contains(gcInfo.getGcNr())) {
            return false;
        }
        if (this.filteringPromotionFailures) {
            boolean foundPromotionFailure = false;
            for (GcEventBase event : gcInfo.getEvents()) {
                if (!(event instanceof GcEventYoungGenPromotionFailure)) continue;
                foundPromotionFailure = true;
                break;
            }
            if (!foundPromotionFailure) {
                return false;
            }
        }
        return true;
    }

    private boolean contains(long gcId) {
        return Collections.binarySearch(this.sortedIds, gcId) >= 0;
    }

    public int hashCode() {
        return this.sortedIds.hashCode() + (this.filteringIds ? 3 : 5) + (this.filteringPromotionFailures ? 7 : 11);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GcFilter)) {
            return false;
        }
        GcFilter tmpFilter = (GcFilter)obj;
        return this.sortedIds.equals(tmpFilter.sortedIds) && this.filteringIds == tmpFilter.filteringIds && this.filteringPromotionFailures == tmpFilter.filteringPromotionFailures;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Filter GC ");
        if (this.filteringPromotionFailures) {
            builder.append("with promotion failures, ");
        }
        builder.append("ids (");
        builder.append(this.filteringIds ? "X): " : " ): ");
        builder.append(this.sortedIds);
        return builder.toString();
    }

    private void appendGcIds(StringBuilder buffer) {
        if (this.sortedIds.isEmpty()) {
            buffer.append("matching no GC id");
            return;
        }
        boolean firstEntry = false;
        for (long id : this.sortedIds) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("id=").append(id);
            firstEntry = false;
        }
    }
}

