/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.snapshot.filter.InputValidatorIdentifier;
import java.util.regex.Pattern;

public abstract class InputValidator {
    protected static final String P_NAME = "([a-zA-Z_$][\\w$]*)";
    protected static final String P_CLASS = "(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)";
    protected static final String P_PARAM_CLASS = "(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*((\\[\\])*(\\.\\.\\.)?))";
    protected static final Pattern CLASS = Pattern.compile("^(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*(\\[\\])*)$");
    protected static final Pattern PR_CLASS = Pattern.compile("^(([a-zA-Z_$][\\w$]*)(\\.([a-zA-Z_$][\\w$]*))*((\\[\\])*(\\.\\.\\.)?))$");
    protected static final Pattern NAME = Pattern.compile("^([a-zA-Z_$][\\w$]*)$");
    private String errMsg = "";
    private int errStart = -1;
    private int errLength = -1;
    private boolean isValidIn = true;
    private boolean isInComplete;
    private boolean advancedState;
    private String input = "";

    public final String getInput() {
        return this.input;
    }

    public final boolean reachedAdvancedSate() {
        return this.advancedState;
    }

    public final boolean isValidInput() {
        return this.isValidIn;
    }

    public final boolean isInputComplete() {
        return this.isInComplete;
    }

    public final String getErrorMessage() {
        return this.errMsg;
    }

    public final int getErrStart() {
        return this.errStart;
    }

    public final int getErrLength() {
        return this.errLength;
    }

    public final void process(String in) {
        this.input = in;
        this.advancedState = false;
        this.validate(this.input);
    }

    protected final void setAdvancedState() {
        this.advancedState = true;
    }

    protected final void setErrMsg(String errMsg, int start, int length) {
        this.errMsg = errMsg;
        this.errStart = start;
        this.errLength = length;
        this.isValidIn = false;
        this.isInComplete = false;
    }

    protected final void setErrMsg(String errMsg) {
        this.setErrMsg(errMsg, -1, -1);
    }

    protected final void resetErrState() {
        this.errMsg = "";
        this.errLength = -1;
        this.errStart = -1;
    }

    protected final void setValidIn() {
        this.isValidIn = true;
        this.isInComplete = false;
        this.resetErrState();
    }

    protected final void setInComplete() {
        this.isInComplete = true;
        this.isValidIn = true;
        this.resetErrState();
    }

    protected abstract void validate(String var1);

    public abstract InputValidatorIdentifier getIdentifier();

    public abstract InputPart[] getRecognizedParts();

    public static class InputPart
    implements Cloneable {
        private String content = "";
        private String oldContent = "";
        private int start;
        private int length;
        private boolean changed;
        private ContentType type;

        public InputPart() {
            this.type = ContentType.NONE;
        }

        public InputPart(ContentType type) {
            this.type = type;
        }

        public InputPart(String content, int start, int length) {
            this.type = ContentType.NONE;
            this.content = content;
            this.start = start;
            this.length = length;
        }

        public InputPart clone() {
            InputPart result = null;
            try {
                result = (InputPart)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return result;
        }

        public ContentType getContentType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        public String getOldContent() {
            return this.oldContent;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public boolean hasChanged() {
            return this.changed;
        }

        public void update(String newContent, int newStart) {
            if (!this.content.equals(newContent)) {
                this.changed = true;
                this.oldContent = this.content;
                this.content = newContent;
            } else {
                this.changed = false;
            }
            this.start = newStart;
            this.length = newContent.length();
        }

        public void update(String newContent, int newStart, int newLength) {
            if (!this.content.equals(newContent)) {
                this.changed = true;
                this.oldContent = this.content;
                this.content = newContent;
            } else {
                this.changed = false;
            }
            this.start = newStart;
            this.length = newLength;
        }

        public void update(String newContent, int newStart, int newLength, ContentType newType) {
            this.type = newType;
            this.update(newContent, newStart, newLength);
        }

        public void update(InputPart part, ContentType newType) {
            this.type = newType;
            this.content = part.oldContent;
            this.update(part.content, part.start, part.length);
        }

        public void update(String newContent, ContentType newType) {
            this.content = newContent;
            this.type = newType;
            this.start = -1;
            this.length = -1;
        }

        public void reset() {
            this.content = "";
            this.oldContent = "";
            this.start = -1;
            this.length = 0;
            this.changed = false;
        }

        public String toString() {
            StringBuilder txt = new StringBuilder('[' + this.content + "] ");
            txt.append(this.getContentType().name());
            return txt.toString();
        }
    }

    public static enum ContentType {
        METHOD_CLASS,
        METHOD_NAME,
        PARAM_CLASS,
        RETURN_CLASS,
        FIELD_NAME,
        CLASS_DEF,
        STATIC_METOD,
        NAME_DEF,
        INTERNAL_MODIFIER,
        NONE;

    }
}

