/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.FilterCache;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilterImpl;
import com.sap.jvm.profiling.snapshot.filter.MethodFilterParser;
import java.io.IOException;

public class MethodFilter
implements SessionAssociated {
    private final MethodFilterImpl filter;
    private final String name;
    private final int hashCode;

    public MethodFilter(ProfilingSession session, String name, String pattern) throws FilterParseException {
        assert (name != null);
        this.filter = FilterCache.intern(new MethodFilterImpl(session, pattern));
        this.hashCode = this.filter.hashCode();
        this.name = name;
    }

    private MethodFilter(ProfilingSession session, String name, MethodObject ... methods) {
        assert (name != null);
        this.filter = FilterCache.intern(new MethodFilterImpl(session, methods));
        this.hashCode = this.filter.hashCode();
        this.name = name;
    }

    public MethodFilter(ClassFilter classFilter, String name) {
        assert (name != null);
        this.filter = FilterCache.intern(new MethodFilterImpl(classFilter));
        this.hashCode = this.filter.hashCode();
        this.name = name;
    }

    public MethodFilter(ResourceReader reader) throws IOException {
        this.filter = FilterCache.intern(new MethodFilterImpl(reader));
        this.hashCode = this.filter.hashCode();
        this.name = reader.readString();
    }

    private MethodFilter(MethodFilterImpl filter, String name) {
        assert (name != null);
        this.filter = FilterCache.intern(filter);
        this.hashCode = filter.hashCode();
        this.name = name;
    }

    public static MethodFilter createForMethods(ProfilingSession session, String name, MethodObject[] methods) {
        return new MethodFilter(session, name, methods);
    }

    public static MethodFilter createNarrow(String name, MethodFilter[] filters, boolean reuseFilter) {
        return new MethodFilter(new MethodFilterImpl(filters, reuseFilter, true), name);
    }

    public static MethodFilter createWide(String name, MethodFilter[] filters, boolean reuseFilter) {
        return new MethodFilter(new MethodFilterImpl(filters, reuseFilter, false), name);
    }

    public static FilterParseException getParseException(String pattern) {
        try {
            new MethodFilterParser().parse(pattern);
            return null;
        }
        catch (FilterParseException e) {
            return e;
        }
    }

    public MethodFilter narrow(String newName, MethodFilter other, boolean reuseFilter) {
        return this.narrow(this.name, new MethodFilter[]{other}, reuseFilter);
    }

    public MethodFilter narrow(String newName, MethodFilter[] others, boolean reuseFilter) {
        MethodFilter[] filters = new MethodFilter[others.length + 1];
        System.arraycopy(others, 0, filters, 1, others.length);
        filters[0] = this;
        return new MethodFilter(new MethodFilterImpl(filters, reuseFilter, true), newName);
    }

    public MethodFilter widen(String newName, MethodFilter other, boolean reuseFilter) {
        return this.widen(newName, new MethodFilter[]{other}, reuseFilter);
    }

    public MethodFilter widen(String newName, MethodFilter[] others, boolean reuseFilter) {
        MethodFilter[] filters = new MethodFilter[others.length + 1];
        System.arraycopy(others, 0, filters, 1, others.length);
        filters[0] = this;
        return new MethodFilter(new MethodFilterImpl(filters, reuseFilter, false), newName);
    }

    public MethodFilter negate(String newName) {
        return new MethodFilter(this.filter.negate(), newName);
    }

    public boolean matches(MethodObject method) {
        return this.filter.matches(method);
    }

    public String getName() {
        return this.name;
    }

    public String asString() {
        return this.filter.asString();
    }

    public void write(ResourceWriter writer) throws IOException {
        this.filter.write(writer);
        writer.writeString(this.name);
    }

    MethodFilterImpl getImpl() {
        return this.filter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodFilter) {
            MethodFilter other = (MethodFilter)obj;
            assert (this.filter.equals((Object)other.filter) == (this.filter == other.filter));
            return this.filter == other.filter;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    public ProfilingSession getSession() {
        return this.filter.getSession();
    }
}

