/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.SessionAssociated;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.StringManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.AbstractFilterParser;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilterImpl;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilterParser;
import com.sap.jvm.profiling.util.AbstractBooleanByIndexCache;
import com.sap.jvm.profiling.util.Glob;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public final class MethodFilterImpl
extends AbstractBooleanByIndexCache
implements SessionAssociated {
    private static final int VERSION = 0;
    private static final int AND_FILTER_NODE = 0;
    private static final int CLASS_FILTER_NODE = 1;
    private static final int FULL_METHOD_NAME_FILTER_NODE = 2;
    private static final int FULL_METHOD_NAME_WITHOUT_SIG_FILTER_NODE = 3;
    private static final int GLOB_METHOD_NAME_FILTER_NODE = 4;
    private static final int MULTI_FILTER_NODE = 5;
    private static final int MULTI_ROOT_NODE = 6;
    private static final int NARROWING_MULTI_FILTER_NODE = 7;
    private static final int NARROWING_MULTI_ROOT_NODE = 8;
    private static final int NOT_FILTER_NODE = 9;
    private static final int OR_FILTER_NODE = 10;
    private static final int OVERWRITES_FULL_FILTER_NODE = 11;
    private static final int OVERWRITES_FULL_WITHOUT_SIG_FILTER_NODE = 12;
    private static final int OVERWRITES_GLOB_FULL_FILTER_NODE = 13;
    private static final int METHOD_LIST_FILTER_NODE = 14;
    private static final int IS_NATIVE_NODE = 15;
    private static final int IS_PUBLIC = 16;
    private static final int IS_PRIVATE = 17;
    private static final int IS_PROTECTED = 18;
    private static final int IS_PACKAGE_PRIVATE = 19;
    private static final int IS_STATIC = 20;
    private static final int IS_DECLARED_FINAL = 21;
    private static final int IS_FINAL = 22;
    private static final int IS_DECLARED_STRICT = 23;
    private static final int IS_STRICT = 24;
    private static final int IS_ABSTRACT = 25;
    private static final int IS_SYNCHRONIZED = 26;
    private static final int IS_SYNTHETIC = 27;
    private static final int IS_OVERWRTING = 28;
    private static final int IS_STATICALLY_CALLABLE = 29;
    private final FilterNode root;
    private final ProfilingSession session;

    private MethodFilterImpl(FilterNode root, ProfilingSession session) {
        this.root = root;
        this.session = session;
    }

    MethodFilterImpl(ProfilingSession session, String pattern) throws FilterParseException {
        this.session = session;
        MethodFilterParser parser = new MethodFilterParser();
        AbstractFilterParser.Node node = parser.parse(pattern);
        this.root = session != null ? this.convertTree(node) : null;
    }

    MethodFilterImpl(ProfilingSession session, MethodObject[] methods) {
        this.session = session;
        this.root = new MethodListFilterNode(methods);
    }

    MethodFilterImpl(MethodFilter[] filters, boolean reuseFilters, boolean narrowing) {
        MethodFilterImpl impl = filters[0].getImpl();
        this.session = impl.session;
        this.root = narrowing ? (reuseFilters ? new NarrowingMultiFilterNode(filters) : new NarrowingMultiRootNode(filters)) : (reuseFilters ? new MultiFilterNode(filters) : new MultiRootNode(filters));
    }

    MethodFilterImpl(ClassFilter classFilter) {
        this.session = classFilter.getImpl().getSession();
        this.root = new ClassFilterNode(classFilter);
    }

    MethodFilterImpl(ResourceReader reader) throws IOException {
        this.session = reader.getSession();
        reader.readVersion(0, 0);
        this.root = MethodFilterImpl.readFilterNode(reader);
    }

    private static FilterNode readFilterNode(ResourceReader reader) throws IOException {
        int tag = reader.readInt32();
        switch (tag) {
            case 0: {
                return new AndFilterNode(reader);
            }
            case 1: {
                return new ClassFilterNode(reader);
            }
            case 2: {
                return new FullMethodNameFilterNode(reader);
            }
            case 3: {
                return new FullMethodNameWithoutSigFilterNode(reader);
            }
            case 4: {
                return new GlobMethodNameFilterNode(reader);
            }
            case 5: {
                return new MultiFilterNode(reader);
            }
            case 6: {
                return new MultiRootNode(reader);
            }
            case 7: {
                return new NarrowingMultiFilterNode(reader);
            }
            case 8: {
                return new NarrowingMultiRootNode(reader);
            }
            case 9: {
                return new NotFilterNode(reader);
            }
            case 10: {
                return new OrFilterNode(reader);
            }
            case 11: {
                return new OverwritesFullFilterNode(reader);
            }
            case 12: {
                return new OverwritesFullWithoutSigFilterNode(reader);
            }
            case 13: {
                return new OverwritesGlobFullFilterNode(reader);
            }
            case 14: {
                return new MethodListFilterNode(reader);
            }
            case 15: {
                return new IsNativeNode();
            }
            case 16: {
                return new IsPublicNode();
            }
            case 17: {
                return new IsPrivateNode();
            }
            case 18: {
                return new IsProtectedNode();
            }
            case 19: {
                return new IsPackagePrivateNode();
            }
            case 20: {
                return new IsStaticNode();
            }
            case 21: {
                return new IsDeclaredFinalNode();
            }
            case 22: {
                return new IsFinalNode();
            }
            case 23: {
                return new IsDeclaredStrictNode();
            }
            case 24: {
                return new IsStrictNode();
            }
            case 25: {
                return new IsAbstractNode();
            }
            case 26: {
                return new IsSynchronizedNode();
            }
            case 27: {
                return new IsSyntheticNode();
            }
            case 28: {
                return new IsOverwritingNode();
            }
            case 29: {
                return new IsStaticallyCallableNode();
            }
        }
        throw new IOException("Unknown tag " + tag);
    }

    void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.root.write(writer);
    }

    public ProfilingSession getSession() {
        return this.session;
    }

    public int hashCode() {
        return this.root.getNodeHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodFilterImpl) {
            MethodFilterImpl other = (MethodFilterImpl)((Object)obj);
            if (this.session != other.session) {
                return false;
            }
            return this.root.isNodeEqual(other.root);
        }
        return false;
    }

    public String toString() {
        return this.asString();
    }

    String asString() {
        return this.root.asString();
    }

    MethodFilterImpl negate() {
        return new MethodFilterImpl(new NotFilterNode(this.root), this.session);
    }

    protected boolean getBooleanImpl(int index) {
        return this.root.matches(this.session.getMethodObject(index));
    }

    boolean matches(MethodObject method) {
        return this.getBoolean(method.getIndex());
    }

    private FilterNode convertTree(AbstractFilterParser.Node node) {
        String keyword = node.getKeyword();
        if ("&".equals(keyword)) {
            return new AndFilterNode(this.convertTree(node.getChild(0)), this.convertTree(node.getChild(1)));
        }
        if ("|".equals(keyword)) {
            return new OrFilterNode(this.convertTree(node.getChild(0)), this.convertTree(node.getChild(1)));
        }
        if ("!".equals(keyword)) {
            return new NotFilterNode(this.convertTree(node.getChild(0)));
        }
        if ("pattern".equals(keyword)) {
            String pattern = node.getParameter().replaceAll(" ", "").replaceAll(",", ", ");
            if (!pattern.contains("*") && !pattern.contains("?")) {
                return new FullMethodNameFilterNode(this.session, pattern);
            }
            if (pattern.endsWith("(*)") && !pattern.contains("?") && pattern.indexOf(42) == pattern.length() - 2) {
                return new FullMethodNameWithoutSigFilterNode(this.session, pattern);
            }
            return new GlobMethodNameFilterNode(pattern);
        }
        if ("overwrites".equals(keyword)) {
            String pattern = node.getParameter().replaceAll(" ", "").replaceAll(",", ", ");
            if (!pattern.contains("*") && !pattern.contains("?")) {
                return new OverwritesFullFilterNode(this.session, pattern);
            }
            if (pattern.endsWith("(*)") && !pattern.contains("?") && pattern.indexOf(42) == pattern.length() - 2) {
                return new OverwritesFullWithoutSigFilterNode(this.session, pattern);
            }
            return new OverwritesGlobFullFilterNode(pattern);
        }
        if ("is_native".equals(keyword)) {
            return new IsNativeNode();
        }
        if ("is_private".equals(keyword)) {
            return new IsPrivateNode();
        }
        if ("is_protected".equals(keyword)) {
            return new IsProtectedNode();
        }
        if ("is_package_private".equals(keyword)) {
            return new IsPackagePrivateNode();
        }
        if ("is_public".equals(keyword)) {
            return new IsPublicNode();
        }
        if ("is_static".equals(keyword)) {
            return new IsStaticNode();
        }
        if ("is_declared_final".equals(keyword)) {
            return new IsDeclaredFinalNode();
        }
        if ("is_final".equals(keyword)) {
            return new IsFinalNode();
        }
        if ("is_declared_strict".equals(keyword)) {
            return new IsDeclaredStrictNode();
        }
        if ("is_strict".equals(keyword)) {
            return new IsStrictNode();
        }
        if ("is_abstract".equals(keyword)) {
            return new IsAbstractNode();
        }
        if ("is_synchronized".equals(keyword)) {
            return new IsSynchronizedNode();
        }
        if ("is_synthetic".equals(keyword)) {
            return new IsSyntheticNode();
        }
        if ("is_overwriting".equals(keyword)) {
            return new IsOverwritingNode();
        }
        if ("is_statically_callable".equals(keyword)) {
            return new IsStaticallyCallableNode();
        }
        assert (false);
        return null;
    }

    private static final class IsStaticallyCallableNode
    implements FilterNode {
        private IsStaticallyCallableNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isStaticallyCallable();
        }

        @Override
        public String asString() {
            return "is_statically_callable";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049685;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsStaticallyCallableNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(29);
        }
    }

    private static final class IsOverwritingNode
    implements FilterNode {
        private IsOverwritingNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isOverwriting();
        }

        @Override
        public String asString() {
            return "is_overwriting";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049686;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsOverwritingNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(28);
        }
    }

    private static final class IsSyntheticNode
    implements FilterNode {
        private IsSyntheticNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isSynthetic();
        }

        @Override
        public String asString() {
            return "is_synthetic";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049688;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsSyntheticNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(27);
        }
    }

    private static final class IsSynchronizedNode
    implements FilterNode {
        private IsSynchronizedNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isSynchronized();
        }

        @Override
        public String asString() {
            return "is_synchronized";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049696;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsSynchronizedNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(26);
        }
    }

    private static final class IsAbstractNode
    implements FilterNode {
        private IsAbstractNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isAbstract();
        }

        @Override
        public String asString() {
            return "is_abstract";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049698;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsAbstractNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(25);
        }
    }

    private static final class IsStrictNode
    implements FilterNode {
        private IsStrictNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isStrict();
        }

        @Override
        public String asString() {
            return "is_strict";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049700;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsStrictNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(24);
        }
    }

    private static final class IsDeclaredStrictNode
    implements FilterNode {
        private IsDeclaredStrictNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isStrict();
        }

        @Override
        public String asString() {
            return "is_declared_strict";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049702;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsDeclaredStrictNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(23);
        }
    }

    private static final class IsFinalNode
    implements FilterNode {
        private IsFinalNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isFinal() || method.getMethodClass().isFinal();
        }

        @Override
        public String asString() {
            return "is_final";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049704;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsFinalNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(22);
        }
    }

    private static final class IsDeclaredFinalNode
    implements FilterNode {
        private IsDeclaredFinalNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isFinal();
        }

        @Override
        public String asString() {
            return "is_declared_final";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049712;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsDeclaredFinalNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(21);
        }
    }

    private static final class IsStaticNode
    implements FilterNode {
        private IsStaticNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isStatic();
        }

        @Override
        public String asString() {
            return "is_static";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049713;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsStaticNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(20);
        }
    }

    private static final class IsPackagePrivateNode
    implements FilterNode {
        private IsPackagePrivateNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isPackagePrivate();
        }

        @Override
        public String asString() {
            return "is_package_private";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049705;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPackagePrivateNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(19);
        }
    }

    private static final class IsProtectedNode
    implements FilterNode {
        private IsProtectedNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isProtected();
        }

        @Override
        public String asString() {
            return "is_protected";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049703;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsProtectedNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(18);
        }
    }

    private static final class IsPrivateNode
    implements FilterNode {
        private IsPrivateNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isPrivate();
        }

        @Override
        public String asString() {
            return "is_private";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049701;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPrivateNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(17);
        }
    }

    private static final class IsPublicNode
    implements FilterNode {
        private IsPublicNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isPublic();
        }

        @Override
        public String asString() {
            return "is_public";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049699;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsPublicNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(16);
        }
    }

    private static final class IsNativeNode
    implements FilterNode {
        private IsNativeNode() {
        }

        @Override
        public boolean matches(MethodObject method) {
            return method.isNative();
        }

        @Override
        public String asString() {
            return "is_native";
        }

        @Override
        public int getNodeHashCode() {
            return 2020049697;
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            return node instanceof IsNativeNode;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(15);
        }
    }

    private static final class ClassFilterNode
    implements FilterNode {
        private final ClassFilterImpl filter;

        public ClassFilterNode(ClassFilter filter) {
            this.filter = filter.getImpl();
        }

        public ClassFilterNode(ResourceReader reader) throws IOException {
            this.filter = new ClassFilterImpl(reader);
        }

        @Override
        public boolean matches(MethodObject method) {
            return this.filter.matches((ClassObject)method.getMethodClass());
        }

        @Override
        public String asString() {
            return "ClassFilter: " + this.filter.asString();
        }

        @Override
        public int getNodeHashCode() {
            return ClassFilterNode.class.hashCode() ^ this.filter.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof ClassFilterNode) {
                ClassFilterNode other = (ClassFilterNode)node;
                return this.filter.equals((Object)other.filter);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(1);
            this.filter.write(writer);
        }
    }

    private static final class NarrowingMultiFilterNode
    implements FilterNode {
        private final MethodFilterImpl[] filters;

        public NarrowingMultiFilterNode(MethodFilter[] filters) {
            this.filters = new MethodFilterImpl[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.filters[i] = filters[i].getImpl();
            }
        }

        public NarrowingMultiFilterNode(ResourceReader reader) throws IOException {
            int nrOfFilters = reader.readInt32();
            this.filters = new MethodFilterImpl[nrOfFilters];
            for (int i = 0; i < nrOfFilters; ++i) {
                this.filters[i] = new MethodFilterImpl(reader);
            }
        }

        @Override
        public boolean matches(MethodObject method) {
            for (MethodFilterImpl filter : this.filters) {
                if (filter.matches(method)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.filters.length; ++i) {
                if (i != 0) {
                    result.append(" & ");
                }
                result.append("(");
                result.append(this.filters[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return NarrowingMultiFilterNode.class.hashCode() ^ Arrays.hashCode((Object[])this.filters);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof NarrowingMultiFilterNode) {
                NarrowingMultiFilterNode other = (NarrowingMultiFilterNode)node;
                return Arrays.equals((Object[])this.filters, (Object[])other.filters);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(7);
            writer.writeInt32(this.filters.length);
            for (MethodFilterImpl filter : this.filters) {
                filter.write(writer);
            }
        }
    }

    private static final class NarrowingMultiRootNode
    implements FilterNode {
        private final FilterNode[] roots;

        public NarrowingMultiRootNode(MethodFilter[] filters) {
            this.roots = new FilterNode[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.roots[i] = filters[i].getImpl().root;
            }
        }

        public NarrowingMultiRootNode(ResourceReader reader) throws IOException {
            int nrOfRoots = reader.readInt32();
            this.roots = new FilterNode[nrOfRoots];
            for (int i = 0; i < nrOfRoots; ++i) {
                this.roots[i] = MethodFilterImpl.readFilterNode(reader);
            }
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.roots.length; ++i) {
                if (i != 0) {
                    result.append(" & ");
                }
                result.append("(");
                result.append(this.roots[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public boolean matches(MethodObject method) {
            for (FilterNode node : this.roots) {
                if (node.matches(method)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getNodeHashCode() {
            int result = 0;
            for (FilterNode node : this.roots) {
                result ^= node.getNodeHashCode();
            }
            return result ^ NarrowingMultiRootNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof NarrowingMultiRootNode) {
                NarrowingMultiRootNode other = (NarrowingMultiRootNode)node;
                if (this.roots.length != other.roots.length) {
                    return false;
                }
                for (int i = 0; i < this.roots.length; ++i) {
                    if (this.roots[i].isNodeEqual(other.roots[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(8);
            writer.writeInt32(this.roots.length);
            for (FilterNode node : this.roots) {
                node.write(writer);
            }
        }
    }

    private static final class MultiFilterNode
    implements FilterNode {
        private final MethodFilterImpl[] filters;

        public MultiFilterNode(MethodFilter[] filters) {
            this.filters = new MethodFilterImpl[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.filters[i] = filters[i].getImpl();
            }
        }

        public MultiFilterNode(ResourceReader reader) throws IOException {
            int nrOfFilters = reader.readInt32();
            this.filters = new MethodFilterImpl[nrOfFilters];
            for (int i = 0; i < nrOfFilters; ++i) {
                this.filters[i] = new MethodFilterImpl(reader);
            }
        }

        @Override
        public boolean matches(MethodObject method) {
            for (MethodFilterImpl filter : this.filters) {
                if (!filter.matches(method)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.filters.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append("(");
                result.append(this.filters[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public int getNodeHashCode() {
            return NarrowingMultiFilterNode.class.hashCode() ^ Arrays.hashCode((Object[])this.filters);
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiFilterNode) {
                MultiFilterNode other = (MultiFilterNode)node;
                return Arrays.equals((Object[])this.filters, (Object[])other.filters);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(5);
            writer.writeInt32(this.filters.length);
            for (MethodFilterImpl filter : this.filters) {
                filter.write(writer);
            }
        }
    }

    private static final class MultiRootNode
    implements FilterNode {
        private final FilterNode[] roots;

        public MultiRootNode(MethodFilter[] filters) {
            this.roots = new FilterNode[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                this.roots[i] = filters[i].getImpl().root;
            }
        }

        public MultiRootNode(ResourceReader reader) throws IOException {
            int nrOfRoots = reader.readInt32();
            this.roots = new FilterNode[nrOfRoots];
            for (int i = 0; i < nrOfRoots; ++i) {
                this.roots[i] = MethodFilterImpl.readFilterNode(reader);
            }
        }

        @Override
        public String asString() {
            StringBuilder result = new StringBuilder("(");
            for (int i = 0; i < this.roots.length; ++i) {
                if (i != 0) {
                    result.append(" | ");
                }
                result.append("(");
                result.append(this.roots[i].asString());
                result.append(")");
            }
            result.append(")");
            return result.toString();
        }

        @Override
        public boolean matches(MethodObject method) {
            for (FilterNode node : this.roots) {
                if (!node.matches(method)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getNodeHashCode() {
            int result = 0;
            for (FilterNode node : this.roots) {
                result ^= node.getNodeHashCode();
            }
            return result ^ MultiRootNode.class.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MultiRootNode) {
                MultiRootNode other = (MultiRootNode)node;
                if (this.roots.length != other.roots.length) {
                    return false;
                }
                for (int i = 0; i < this.roots.length; ++i) {
                    if (this.roots[i].isNodeEqual(other.roots[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(6);
            writer.writeInt32(this.roots.length);
            for (FilterNode node : this.roots) {
                node.write(writer);
            }
        }
    }

    private static final class OverwritesGlobFullFilterNode
    implements FilterNode {
        private final String pattern;
        private final Glob matcher;

        public OverwritesGlobFullFilterNode(String pattern) {
            this.pattern = pattern;
            this.matcher = new Glob(pattern);
        }

        public OverwritesGlobFullFilterNode(ResourceReader reader) throws IOException {
            this.pattern = reader.readString();
            this.matcher = new Glob(this.pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(MethodObject method) {
            String methodNameAndSig = method.getName() + "(" + method.getSignature() + ")";
            NonArrayClassObject methodClass = method.getMethodClass();
            StringBuilder fullName = new StringBuilder();
            for (NonArrayClassObject superClass = methodClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                fullName.append(superClass.getFullName());
                fullName.append('.');
                fullName.append(methodNameAndSig);
                Glob glob = this.matcher;
                synchronized (glob) {
                    if (this.matcher.isFullMatch(fullName.toString())) {
                        return true;
                    }
                }
                fullName.setLength(0);
            }
            return this.matchInterfaces(methodClass, methodNameAndSig, fullName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean matchInterfaces(NonArrayClassObject clazz, String methodNameAndSig, StringBuilder fullName) {
            for (int i = clazz.getNrOfInterfaces() - 1; i >= 0; --i) {
                NonArrayClassObject currInterface = clazz.getInterface(i);
                fullName.append(currInterface.getFullName());
                fullName.append('.');
                fullName.append(methodNameAndSig);
                Glob glob = this.matcher;
                synchronized (glob) {
                    if (this.matcher.isFullMatch(fullName.toString())) {
                        return true;
                    }
                }
                fullName.setLength(0);
                if (!this.matchInterfaces(currInterface, methodNameAndSig, fullName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            return "overwrites " + this.pattern;
        }

        @Override
        public int getNodeHashCode() {
            return OverwritesGlobFullFilterNode.class.hashCode() ^ this.pattern.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof OverwritesGlobFullFilterNode) {
                OverwritesGlobFullFilterNode other = (OverwritesGlobFullFilterNode)node;
                return this.pattern.equals(other.pattern);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(13);
            writer.writeString(this.pattern);
        }
    }

    private static final class OverwritesFullWithoutSigFilterNode
    implements FilterNode {
        private final MethodNamesParts parts;
        private final ProfilingSession session;
        private final String pattern;

        public OverwritesFullWithoutSigFilterNode(ProfilingSession session, String pattern) {
            assert (pattern.indexOf(42) == pattern.length() - 2);
            assert (!pattern.contains("?"));
            assert (pattern.endsWith("(*)"));
            this.pattern = pattern;
            this.parts = new MethodNamesParts(session.getStringManager(), pattern);
            this.session = session;
        }

        public OverwritesFullWithoutSigFilterNode(ResourceReader reader) throws IOException {
            this.session = reader.getSession();
            this.pattern = reader.readString();
            this.parts = new MethodNamesParts(this.session.getStringManager(), this.pattern);
        }

        @Override
        public boolean matches(MethodObject method) {
            assert (method.getSession() == this.session);
            if (!this.parts.matchesMethodName(method)) {
                return false;
            }
            NonArrayClassObject methodClass = method.getMethodClass();
            for (NonArrayClassObject superClass = methodClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                if (!this.parts.matchesClassAndPackage(superClass)) continue;
                return true;
            }
            return this.matchInterfaces(methodClass);
        }

        private boolean matchInterfaces(NonArrayClassObject clazz) {
            for (int i = clazz.getNrOfInterfaces() - 1; i >= 0; --i) {
                NonArrayClassObject currInterface = clazz.getInterface(i);
                if (this.parts.matchesClassAndPackage(currInterface)) {
                    return true;
                }
                if (!this.matchInterfaces(currInterface)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            return "overwrites " + this.parts.toString();
        }

        @Override
        public int getNodeHashCode() {
            return OverwritesFullWithoutSigFilterNode.class.hashCode() ^ this.parts.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof OverwritesFullWithoutSigFilterNode) {
                OverwritesFullWithoutSigFilterNode other = (OverwritesFullWithoutSigFilterNode)node;
                return this.parts.equals(other.parts);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(12);
            writer.writeString(this.pattern);
        }
    }

    private static final class OverwritesFullFilterNode
    implements FilterNode {
        private final MethodNamesParts parts;
        private final ProfilingSession session;
        private final String pattern;

        public OverwritesFullFilterNode(ProfilingSession session, String pattern) {
            assert (!pattern.contains("*"));
            assert (!pattern.contains("?"));
            this.pattern = pattern;
            this.parts = new MethodNamesParts(session.getStringManager(), pattern);
            this.session = session;
        }

        public OverwritesFullFilterNode(ResourceReader reader) throws IOException {
            this.session = reader.getSession();
            this.pattern = reader.readString();
            this.parts = new MethodNamesParts(this.session.getStringManager(), this.pattern);
        }

        @Override
        public boolean matches(MethodObject method) {
            assert (method.getSession() == this.session);
            if (!this.parts.matchesMethodNameAndSig(method)) {
                return false;
            }
            NonArrayClassObject methodClass = method.getMethodClass();
            for (NonArrayClassObject superClass = methodClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                if (!this.parts.matchesClassAndPackage(superClass)) continue;
                return true;
            }
            return this.matchInterfaces(methodClass);
        }

        private boolean matchInterfaces(NonArrayClassObject clazz) {
            for (int i = clazz.getNrOfInterfaces() - 1; i >= 0; --i) {
                NonArrayClassObject currInterface = clazz.getInterface(i);
                if (this.parts.matchesClassAndPackage(currInterface)) {
                    return true;
                }
                if (!this.matchInterfaces(currInterface)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String asString() {
            return "overwrites " + this.parts.toString();
        }

        @Override
        public int getNodeHashCode() {
            return OverwritesFullFilterNode.class.hashCode() ^ this.parts.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof OverwritesFullFilterNode) {
                OverwritesFullFilterNode other = (OverwritesFullFilterNode)node;
                return this.parts.equals(other.parts);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(11);
            writer.writeString(this.pattern);
        }
    }

    private static final class GlobMethodNameFilterNode
    implements FilterNode {
        private final String pattern;
        private final Glob matcher;

        public GlobMethodNameFilterNode(String pattern) {
            this.pattern = pattern;
            this.matcher = new Glob(pattern);
        }

        public GlobMethodNameFilterNode(ResourceReader reader) throws IOException {
            this.pattern = reader.readString();
            this.matcher = new Glob(this.pattern);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(MethodObject method) {
            Glob glob = this.matcher;
            synchronized (glob) {
                return this.matcher.isFullMatch(method.getFullNameWithoutReturnType());
            }
        }

        @Override
        public String asString() {
            return this.pattern;
        }

        @Override
        public int getNodeHashCode() {
            return GlobMethodNameFilterNode.class.hashCode() ^ this.pattern.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof GlobMethodNameFilterNode) {
                GlobMethodNameFilterNode other = (GlobMethodNameFilterNode)node;
                return this.pattern.equals(other.pattern);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(4);
            writer.writeString(this.pattern);
        }
    }

    private static final class FullMethodNameWithoutSigFilterNode
    implements FilterNode {
        private final MethodNamesParts parts;
        private final ProfilingSession session;
        private final String pattern;

        public FullMethodNameWithoutSigFilterNode(ProfilingSession session, String pattern) {
            assert (pattern.indexOf(42) == pattern.length() - 2);
            assert (!pattern.contains("?"));
            assert (pattern.endsWith("(*)"));
            this.pattern = pattern;
            this.parts = new MethodNamesParts(session.getStringManager(), pattern);
            this.session = session;
        }

        public FullMethodNameWithoutSigFilterNode(ResourceReader reader) throws IOException {
            this.session = reader.getSession();
            this.pattern = reader.readString();
            this.parts = new MethodNamesParts(this.session.getStringManager(), this.pattern);
        }

        @Override
        public boolean matches(MethodObject method) {
            assert (method.getSession() == this.session);
            return this.parts.matchesAllWithoutSig(method);
        }

        @Override
        public String asString() {
            return this.parts.toString();
        }

        @Override
        public int getNodeHashCode() {
            return FullMethodNameWithoutSigFilterNode.class.hashCode() ^ this.parts.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof FullMethodNameWithoutSigFilterNode) {
                FullMethodNameWithoutSigFilterNode other = (FullMethodNameWithoutSigFilterNode)node;
                return this.parts.equals(other.parts);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(3);
            writer.writeString(this.pattern);
        }
    }

    private static final class FullMethodNameFilterNode
    implements FilterNode {
        private final MethodNamesParts parts;
        private final ProfilingSession session;
        private final String pattern;

        public FullMethodNameFilterNode(ProfilingSession session, String pattern) {
            assert (!pattern.contains("*"));
            assert (!pattern.contains("?"));
            this.pattern = pattern;
            this.parts = new MethodNamesParts(session.getStringManager(), pattern);
            this.session = session;
        }

        public FullMethodNameFilterNode(ResourceReader reader) throws IOException {
            this.session = reader.getSession();
            this.pattern = reader.readString();
            this.parts = new MethodNamesParts(this.session.getStringManager(), this.pattern);
        }

        @Override
        public boolean matches(MethodObject method) {
            assert (method.getSession() == this.session);
            return this.parts.matchesAll(method);
        }

        @Override
        public String asString() {
            return this.parts.toString();
        }

        @Override
        public int getNodeHashCode() {
            return FullMethodNameFilterNode.class.hashCode() ^ this.parts.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof FullMethodNameFilterNode) {
                FullMethodNameFilterNode other = (FullMethodNameFilterNode)node;
                return this.parts.equals(other.parts);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(2);
            writer.writeString(this.pattern);
        }
    }

    private static final class MethodNamesParts {
        private final UTF8String packageNameUTF;
        private final UTF8String classNameUTF;
        private final UTF8String methodNameUTF;
        private final UTF8String signatureUTF;

        public MethodNamesParts(StringManager manager, String fullName) {
            int sigIndex = fullName.indexOf(40);
            String signature = fullName.substring(sigIndex + 1, fullName.length() - 1);
            signature = signature.replaceAll("\\s", "");
            String classAndMethodName = fullName.substring(0, sigIndex);
            int methodIndex = classAndMethodName.lastIndexOf(46);
            if (methodIndex >= 0 && methodIndex < sigIndex) {
                String className;
                String methodName = classAndMethodName.substring(methodIndex + 1);
                String classAndPackageName = classAndMethodName.substring(0, methodIndex);
                int classIndex = classAndPackageName.lastIndexOf(46);
                String packageName = "";
                if (classIndex >= 0) {
                    packageName = classAndPackageName.substring(0, classIndex);
                    className = classAndPackageName.substring(classIndex + 1, classAndPackageName.length());
                } else {
                    className = classAndPackageName;
                }
                this.packageNameUTF = manager.intern(packageName);
                this.classNameUTF = manager.intern(className);
                this.methodNameUTF = manager.intern(methodName);
            } else {
                this.packageNameUTF = manager.intern("");
                this.classNameUTF = manager.intern("");
                this.methodNameUTF = manager.intern(fullName.substring(0, sigIndex));
            }
            this.signatureUTF = manager.intern(signature);
        }

        public boolean matchesClassAndPackage(NonArrayClassObject clazz) {
            if (this.classNameUTF.isEmpty()) {
                return true;
            }
            return clazz.getPackageNameUTF().equals(this.packageNameUTF) && clazz.getNameUTF().equals(this.classNameUTF);
        }

        public boolean matchesMethodNameAndSig(MethodObject method) {
            return method.getNameUTF().equals(this.methodNameUTF) && method.getSignatureUTF().equals(this.signatureUTF);
        }

        public boolean matchesMethodName(MethodObject method) {
            return method.getNameUTF().equals(this.methodNameUTF);
        }

        public boolean matchesAllWithoutSig(MethodObject method) {
            return this.matchesMethodName(method) && this.matchesClassAndPackage(method.getMethodClass());
        }

        public boolean matchesAll(MethodObject method) {
            return this.matchesMethodNameAndSig(method) && this.matchesClassAndPackage(method.getMethodClass());
        }

        public String toString() {
            if (this.classNameUTF.isEmpty()) {
                return this.methodNameUTF + "(" + this.signatureUTF + ")";
            }
            if (this.packageNameUTF.isEmpty()) {
                return this.classNameUTF + "." + this.methodNameUTF + "(" + this.signatureUTF + ")";
            }
            return this.packageNameUTF + "." + this.classNameUTF + "." + this.methodNameUTF + "(" + this.signatureUTF + ")";
        }

        public int hashCode() {
            return this.packageNameUTF.hashCode() ^ this.classNameUTF.hashCode() ^ this.classNameUTF.hashCode() ^ this.signatureUTF.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof MethodNamesParts) {
                MethodNamesParts other = (MethodNamesParts)o;
                return this.packageNameUTF.equals(other.packageNameUTF) && this.classNameUTF.equals(other.classNameUTF) && this.methodNameUTF.equals(other.methodNameUTF) && this.signatureUTF.equals(other.signatureUTF);
            }
            return false;
        }
    }

    private static final class NotFilterNode
    implements FilterNode {
        private final FilterNode node;

        public NotFilterNode(FilterNode node) {
            this.node = node;
        }

        public NotFilterNode(ResourceReader reader) throws IOException {
            this.node = MethodFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(MethodObject method) {
            return !this.node.matches(method);
        }

        @Override
        public String asString() {
            return "(!" + this.node.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return NotFilterNode.class.hashCode() ^ this.node.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode other) {
            if (other instanceof NotFilterNode) {
                return this.node.isNodeEqual(((NotFilterNode)other).node);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(9);
            this.node.write(writer);
        }
    }

    private static final class OrFilterNode
    implements FilterNode {
        private final FilterNode node1;
        private final FilterNode node2;

        public OrFilterNode(FilterNode node1, FilterNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        public OrFilterNode(ResourceReader reader) throws IOException {
            this.node1 = MethodFilterImpl.readFilterNode(reader);
            this.node2 = MethodFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(MethodObject method) {
            return this.node1.matches(method) || this.node2.matches(method);
        }

        @Override
        public String asString() {
            return "(" + this.node1.asString() + " || " + this.node2.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return OrFilterNode.class.hashCode() ^ this.node1.getNodeHashCode() ^ this.node2.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof OrFilterNode) {
                OrFilterNode otherNode = (OrFilterNode)node;
                return this.node1.isNodeEqual(otherNode.node1) && this.node2.isNodeEqual(otherNode.node2);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(10);
            this.node1.write(writer);
            this.node2.write(writer);
        }
    }

    private static final class AndFilterNode
    implements FilterNode {
        private final FilterNode node1;
        private final FilterNode node2;

        public AndFilterNode(FilterNode node1, FilterNode node2) {
            this.node1 = node1;
            this.node2 = node2;
        }

        public AndFilterNode(ResourceReader reader) throws IOException {
            this.node1 = MethodFilterImpl.readFilterNode(reader);
            this.node2 = MethodFilterImpl.readFilterNode(reader);
        }

        @Override
        public boolean matches(MethodObject method) {
            return this.node1.matches(method) && this.node2.matches(method);
        }

        @Override
        public String asString() {
            return "(" + this.node1.asString() + " && " + this.node2.asString() + ")";
        }

        @Override
        public int getNodeHashCode() {
            return AndFilterNode.class.hashCode() ^ this.node1.getNodeHashCode() ^ this.node2.getNodeHashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof AndFilterNode) {
                AndFilterNode otherNode = (AndFilterNode)node;
                return this.node1.isNodeEqual(otherNode.node1) && this.node2.isNodeEqual(otherNode.node2);
            }
            return false;
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(0);
            this.node1.write(writer);
            this.node2.write(writer);
        }
    }

    private static final class MethodListFilterNode
    implements FilterNode {
        private final HashSet<MethodObject> methods = new HashSet();

        public MethodListFilterNode(MethodObject[] methods) {
            for (MethodObject method : methods) {
                this.methods.add(method);
            }
        }

        public MethodListFilterNode(ResourceReader reader) throws IOException {
            int size = reader.readInt32();
            for (int i = 0; i < size; ++i) {
                this.methods.add(reader.readMethodObject());
            }
        }

        @Override
        public String asString() {
            return Arrays.toString(this.methods.toArray());
        }

        @Override
        public int getNodeHashCode() {
            return this.methods.hashCode();
        }

        @Override
        public boolean isNodeEqual(FilterNode node) {
            if (node instanceof MethodListFilterNode) {
                return this.methods.equals(((MethodListFilterNode)node).methods);
            }
            return false;
        }

        @Override
        public boolean matches(MethodObject method) {
            return this.methods.contains(method);
        }

        @Override
        public void write(ResourceWriter writer) throws IOException {
            writer.writeInt32(14);
            writer.writeInt32(this.methods.size());
            for (MethodObject method : this.methods) {
                writer.writeMethodObject(method);
            }
        }
    }

    private static interface FilterNode {
        public boolean matches(MethodObject var1);

        public String asString();

        public boolean isNodeEqual(FilterNode var1);

        public int getNodeHashCode();

        public void write(ResourceWriter var1) throws IOException;
    }
}

