/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.snapshot.filter.AbstractFilterParser;

public class MethodFilterParser
extends AbstractFilterParser {
    @Override
    protected String checkExpression(String keyword, AbstractFilterParser.Node expression) {
        return null;
    }

    @Override
    protected AbstractFilterParser.ErrorSpec checkParameter(String keyword, String parameter) {
        return this.checkPattern(parameter);
    }

    @Override
    protected AbstractFilterParser.ErrorSpec checkPattern(String str) {
        int len = str.length();
        boolean containsWildcard = false;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '?' || c == '*') {
                containsWildcard = true;
                continue;
            }
            if (c == '.' || c == '$' || c == '[' || c == ']' || c == '(' || c == ')' || c == ' ' || c == ',' || c == '<' || c == '>' || Character.isJavaIdentifierPart(c)) continue;
            return new AbstractFilterParser.ErrorSpec(i, i + 1, I18n._s((String)"Invalid character '{0}'", (Object[])new Object[]{"" + c}));
        }
        if (!containsWildcard) {
            int p1 = str.indexOf(41);
            int p2 = str.indexOf(40);
            int p3 = str.lastIndexOf(40);
            String error = null;
            int e1 = 0;
            int e2 = str.length();
            if (p2 == -1) {
                error = I18n._s((String)"The opening '(' is missing");
            } else if (p2 != p3) {
                error = I18n._s((String)"Duplicate '(' found");
                e1 = p2;
                e2 = p3 + 1;
            } else if (p1 == -1) {
                error = I18n._s((String)"The closing ')' is missing");
            } else if (p1 != str.length() - 1) {
                error = I18n._s((String)"Found a ')' inside the method");
                e1 = p1;
                e2 = p1 + 1;
            }
            if (error != null) {
                return new AbstractFilterParser.ErrorSpec(e1, e2, I18n._s((String)"Method name must be of the form '<classandmethod>(<signature>)'. {0}", (Object[])new Object[]{error}));
            }
        }
        return null;
    }

    @Override
    protected String[] getKeywordsWithExpression() {
        return new String[0];
    }

    @Override
    protected String[] getKeywordsWithParameter() {
        return new String[]{"overwrites"};
    }

    @Override
    protected String[] getKeywordsWithoutParameters() {
        return new String[]{"is_native", "is_public", "is_private", "is_protected", "is_package_private", "is_static", "is_declared_final", "is_final", "is_declared_strict", "is_strict", "is_abstract", "is_synchronized", "is_synthetic", "is_overwriting", "is_statically_callable"};
    }

    @Override
    protected boolean needsInternalParameters(String keyword) {
        return false;
    }
}

