/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.parameters.MethodParameters;
import com.sap.jvm.profiling.method.parameters.Parameter;
import java.util.HashMap;
import java.util.HashSet;

public final class MethodParameterFilter {
    private HashMap<String, FilterSettings> filters = new HashMap();
    private String currentSpecName;
    private FilterSettings currentFilterSettings;
    private long[] lastChangeCounts = new long[512];
    private boolean[] matchedAll = new boolean[512];

    public void filterBySpecName(String specName) {
        FilterSettings settings = this.filters.get(specName);
        if (settings == null) {
            settings = new FilterSettings();
            this.filters.put(specName, settings);
        }
        this.currentSpecName = specName;
        this.currentFilterSettings = settings;
    }

    public void filterByValues(Parameter[] values) {
        if (this.currentSpecName == null) {
            throw new IllegalStateException("No current method parameter specification");
        }
        FilterSettings settings = this.filters.get(this.currentSpecName);
        settings.values = values;
        this.currentFilterSettings = settings;
    }

    public void filterByInvocationIds(long[] invocationIds) {
        if (this.currentSpecName == null) {
            throw new IllegalStateException("No current method parameter specification");
        }
        FilterSettings settings = this.filters.get(this.currentSpecName);
        settings.invocationIds = invocationIds;
        this.currentFilterSettings = settings;
    }

    private boolean matchesAllCurrent(MethodParameterEntryEvent event) {
        MethodParameters params = event.getParameters();
        for (int i = 0; i < params.getNrOfParameters(); ++i) {
            long[] filterIds;
            if (!this.currentSpecName.equals(params.getSpec(i).getName())) continue;
            Parameter[] filterValues = this.currentFilterSettings.values;
            if (filterValues != null && filterValues.length > 0) {
                Parameter paramValue = params.getParameter(i);
                boolean matched = false;
                for (int j = 0; j < filterValues.length; ++j) {
                    if (!filterValues[j].equals(paramValue)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
            if ((filterIds = this.currentFilterSettings.invocationIds) != null && filterIds.length > 0) {
                for (int j = 0; j < filterIds.length; ++j) {
                    if (filterIds[j] != event.getId()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matchesAll(MethodParameterEntryEvent event) {
        if (event == null && this.filters.isEmpty()) {
            return true;
        }
        if (event == null) {
            return false;
        }
        HashSet<String> pendingSpecs = new HashSet<String>(this.filters.keySet());
        MethodParameters params = event.getParameters();
        block0: for (int i = 0; i < params.getNrOfParameters(); ++i) {
            String specName = params.getSpec(i).getName();
            Parameter paramValue = params.getParameter(i);
            if (!this.filters.containsKey(specName)) continue;
            FilterSettings filterSettings = this.filters.get(specName);
            Parameter[] filterValues = filterSettings.values;
            boolean matched = true;
            if (filterValues != null && filterValues.length > 0) {
                matched = false;
                for (int j = 0; j < filterValues.length; ++j) {
                    if (!filterValues[j].equals(paramValue)) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched) continue;
            long[] filterIds = filterSettings.invocationIds;
            if (filterIds != null && filterIds.length > 0) {
                for (int j = 0; j < filterIds.length; ++j) {
                    if (filterIds[j] != event.getId()) continue;
                    pendingSpecs.remove(specName);
                    continue block0;
                }
                continue;
            }
            pendingSpecs.remove(specName);
        }
        return pendingSpecs.isEmpty();
    }

    private boolean matchesAllImpl(ThreadInfo threadInfo) {
        int topIndex = threadInfo.getEntryEventTop();
        if (topIndex == -1) {
            return this.filters.isEmpty();
        }
        MethodParameterEntryEvent[] events = threadInfo.getEntryEvents();
        if (this.filters.size() == 1) {
            for (int i = topIndex; i >= 0; --i) {
                if (!this.matchesAllCurrent(events[i])) continue;
                return true;
            }
            return false;
        }
        for (int i = topIndex; i >= 0; --i) {
            if (!this.matchesAll(events[i])) continue;
            return true;
        }
        return false;
    }

    public boolean matchesTop(ThreadInfo threadInfo) {
        int topIndex = threadInfo.getEntryEventTop();
        if (topIndex == -1) {
            return this.filters.isEmpty();
        }
        MethodParameterEntryEvent[] events = threadInfo.getEntryEvents();
        if (this.filters.size() == 1) {
            return this.matchesAllCurrent(events[topIndex]);
        }
        return this.matchesAll(events[topIndex]);
    }

    public boolean matchesAll(ThreadInfo threadInfo) {
        char index = (char)('\u0001' + threadInfo.getIndex());
        if (index < this.lastChangeCounts.length) {
            long lastChangeCount = this.lastChangeCounts[index];
            long newChangeCount = threadInfo.getParameterChangeCount();
            if (lastChangeCount != newChangeCount) {
                this.lastChangeCounts[index] = newChangeCount;
                this.matchedAll[index] = this.matchesAllImpl(threadInfo);
            }
            return this.matchedAll[index];
        }
        assert (this.lastChangeCounts.length == this.matchedAll.length);
        int newSize = Math.max(index + '\u0001', this.lastChangeCounts.length * 2);
        long[] newLastChangeCounts = new long[newSize];
        System.arraycopy(this.lastChangeCounts, 0, newLastChangeCounts, 0, this.lastChangeCounts.length);
        this.lastChangeCounts = newLastChangeCounts;
        boolean[] newMatchedAll = new boolean[newSize];
        System.arraycopy(this.matchedAll, 0, newMatchedAll, 0, this.matchedAll.length);
        this.matchedAll = newMatchedAll;
        return this.matchesAll(threadInfo);
    }

    public String getLastParameterName() {
        return this.currentSpecName;
    }

    private class FilterSettings {
        public Parameter[] values;
        public long[] invocationIds;

        private FilterSettings() {
        }
    }
}

