/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.snapshot.filter.InputMethodDefValidator;
import com.sap.jvm.profiling.snapshot.filter.InputValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputArrayDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputCastDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputClassDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputMethodNameDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputModifierDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputModifierMethodDefValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputStaticMethodValidator;
import com.sap.jvm.profiling.snapshot.impl.mpt.util.InputStaticMethodWithoutReturnClassValidator;

public abstract class MethodParameterValidatorFactory {
    public static InputValidator getArrayIndexValidator() {
        return new InputArrayDefValidator();
    }

    public static InputValidator getCastValidator() {
        return new InputCastDefValidator();
    }

    public static InputValidator getSimpleMethodValidator() {
        return new InputModifierMethodDefValidator();
    }

    public static InputValidator getStaticMethodValidator() {
        return new InputStaticMethodValidator();
    }

    public static InputValidator getStaticMethodWhithoutReturnClassValidator() {
        return new InputStaticMethodWithoutReturnClassValidator();
    }

    public static InputValidator getFieldValidator() {
        return new InputCastDefValidator();
    }

    public static InputMethodDefValidator getMethodValidator() {
        return new com.sap.jvm.profiling.snapshot.impl.mpt.util.InputMethodDefValidator();
    }

    public static InputValidator getModifierValidator() {
        return new InputModifierDefValidator();
    }

    public static InputValidator getClassDefValidator() {
        return new InputClassDefValidator();
    }

    public static InputValidator getMethodNameValidator() {
        return new InputMethodNameDefValidator();
    }

    public static void updateParent(InputValidator validator, String parent) {
        ((InputModifierDefValidator)validator).setParentType(parent);
    }

    public static boolean isModifierMethod(String method) {
        return InputModifierMethodDefValidator.METHOD.matcher(method).matches() || InputStaticMethodValidator.METHOD.matcher(method).matches();
    }
}

