/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public final class MonitorFilter {
    private final MonitorObject[] monitors;
    private int hashCode;

    public MonitorFilter(MonitorObject[] monitors) {
        this.monitors = monitors;
        Arrays.sort(monitors, MonitorObject.getComparator());
    }

    public MonitorFilter(ResourceReader reader) throws IOException {
        this.monitors = new MonitorObject[reader.readInt32()];
        for (int i = 0; i < this.monitors.length; ++i) {
            this.monitors[i] = MonitorObject.read((ResourceReader)reader);
        }
        Arrays.sort(this.monitors, MonitorObject.getComparator());
    }

    public MonitorObject[] getMonitors() {
        MonitorObject[] result = new MonitorObject[this.monitors.length];
        System.arraycopy(this.monitors, 0, result, 0, this.monitors.length);
        return result;
    }

    public boolean matches(MonitorObject monitor2) {
        return Arrays.binarySearch(this.monitors, monitor2, MonitorObject.getComparator()) >= 0;
    }

    public MonitorFilter narrow(MonitorFilter other) {
        return this.narrow(new MonitorFilter[]{other});
    }

    public MonitorFilter narrow(MonitorFilter[] others) {
        HashSet<MonitorObject> filters = new HashSet<MonitorObject>();
        filters.addAll(Arrays.asList(this.monitors));
        for (MonitorFilter mf : others) {
            filters.retainAll(Arrays.asList(mf.monitors));
        }
        return new MonitorFilter(filters.toArray(new MonitorObject[filters.size()]));
    }

    public MonitorFilter widen(MonitorFilter other) {
        return this.widen(new MonitorFilter[]{other});
    }

    public MonitorFilter widen(MonitorFilter[] others) {
        HashSet<MonitorObject> filters = new HashSet<MonitorObject>();
        filters.addAll(Arrays.asList(this.monitors));
        for (MonitorFilter mf : others) {
            filters.addAll(Arrays.asList(mf.monitors));
        }
        return new MonitorFilter(filters.toArray(new MonitorObject[filters.size()]));
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.monitors.length);
        for (MonitorObject m : this.monitors) {
            m.write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MonitorFilter) {
            MonitorFilter filter = (MonitorFilter)obj;
            int h1 = this.hashCode;
            int h2 = filter.hashCode;
            if (h1 != h2 && h1 != 0 && h2 != 0) {
                return false;
            }
            return Arrays.equals(this.monitors, filter.monitors);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.monitors);
            this.hashCode = this.hashCode == 0 ? 1 : this.hashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        return Arrays.toString(this.monitors);
    }
}

