/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.sync.ReentrantLockObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public final class ReentrantLockFilter {
    private final ReentrantLockObject[] locks;
    private int hashCode;

    public ReentrantLockFilter(ReentrantLockObject[] locks) {
        this.locks = locks;
        Arrays.sort(locks, ReentrantLockObject.getComparator());
    }

    public ReentrantLockFilter(ResourceReader reader) throws IOException {
        this.locks = new ReentrantLockObject[reader.readInt32()];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = ReentrantLockObject.read(reader);
        }
        Arrays.sort(this.locks, ReentrantLockObject.getComparator());
    }

    public ReentrantLockObject[] getLocks() {
        ReentrantLockObject[] result = new ReentrantLockObject[this.locks.length];
        System.arraycopy(this.locks, 0, result, 0, this.locks.length);
        return result;
    }

    public boolean matches(ReentrantLockObject lock) {
        return Arrays.binarySearch(this.locks, lock, ReentrantLockObject.getComparator()) >= 0;
    }

    public ReentrantLockFilter narrow(ReentrantLockFilter other) {
        return this.narrow(new ReentrantLockFilter[]{other});
    }

    public ReentrantLockFilter narrow(ReentrantLockFilter[] others) {
        HashSet<ReentrantLockObject> filters = new HashSet<ReentrantLockObject>();
        filters.addAll(Arrays.asList(this.locks));
        for (ReentrantLockFilter mf : others) {
            filters.retainAll(Arrays.asList(mf.locks));
        }
        return new ReentrantLockFilter(filters.toArray(new ReentrantLockObject[filters.size()]));
    }

    public ReentrantLockFilter widen(ReentrantLockFilter other) {
        return this.widen(new ReentrantLockFilter[]{other});
    }

    public ReentrantLockFilter widen(ReentrantLockFilter[] others) {
        HashSet<ReentrantLockObject> filters = new HashSet<ReentrantLockObject>();
        filters.addAll(Arrays.asList(this.locks));
        for (ReentrantLockFilter mf : others) {
            filters.addAll(Arrays.asList(mf.locks));
        }
        return new ReentrantLockFilter(filters.toArray(new ReentrantLockObject[filters.size()]));
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.locks.length);
        for (ReentrantLockObject l : this.locks) {
            l.write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReentrantLockFilter) {
            ReentrantLockFilter filter = (ReentrantLockFilter)obj;
            int h1 = this.hashCode;
            int h2 = filter.hashCode;
            if (h1 != h2 && h1 != 0 && h2 != 0) {
                return false;
            }
            return Arrays.equals(this.locks, filter.locks);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.locks);
            this.hashCode = this.hashCode == 0 ? 1 : this.hashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        return Arrays.toString(this.locks);
    }
}

