/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.snapshot.net.NetworkConnection;
import com.sap.jvm.profiling.snapshot.net.NetworkConnectionSideType;
import com.sap.jvm.profiling.snapshot.net.NetworkHost;
import com.sap.jvm.profiling.snapshot.net.NetworkService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public final class SocketFilter {
    private HashSet<NetworkConnection> connections = new HashSet();
    private ArrayList<Long> sortedIds = new ArrayList();
    private HashSet<NetworkService> services = new HashSet();
    private HashSet<IpAddress> hosts = new HashSet();
    private boolean filteringIds = false;
    private boolean filteringConnections = false;
    private boolean filteringServices = false;
    private boolean filteringHosts = false;

    public boolean isFiltering() {
        return this.filteringIds || this.filteringConnections || this.filteringServices || this.filteringHosts;
    }

    public boolean isFilteringId() {
        return this.filteringIds;
    }

    public boolean isFilteringConnections() {
        return this.filteringConnections;
    }

    public boolean isFilteringServices() {
        return this.filteringServices;
    }

    public boolean isFilteringHosts() {
        return this.filteringHosts;
    }

    public String asString() {
        StringBuilder buffer = new StringBuilder();
        if (this.filteringConnections) {
            this.appendSocketConnections(buffer);
        }
        if (this.filteringIds) {
            this.appendSocketIds(buffer);
        }
        if (this.filteringServices) {
            this.appendNetworkServices(buffer);
        }
        if (this.filteringHosts) {
            this.appendNetworkHosts(buffer);
        }
        return buffer.toString();
    }

    public SocketFilter copy() {
        SocketFilter result = new SocketFilter();
        result.connections = new HashSet<NetworkConnection>(this.connections);
        result.sortedIds = new ArrayList<Long>(this.sortedIds);
        result.services = new HashSet<NetworkService>(this.services);
        result.hosts = new HashSet<IpAddress>(this.hosts);
        result.filteringIds = this.filteringIds;
        result.filteringConnections = this.filteringConnections;
        result.filteringServices = this.filteringServices;
        result.filteringHosts = this.filteringHosts;
        return result;
    }

    public void narrow(SocketFilter otherFilter) {
        if (!this.filteringIds) {
            this.filteringIds = otherFilter.filteringIds;
            this.sortedIds.addAll(otherFilter.sortedIds);
        } else if (otherFilter.filteringIds) {
            ArrayList<Long> tmpIds = new ArrayList<Long>();
            Iterator<Object> iterator = this.sortedIds.iterator();
            while (iterator.hasNext()) {
                long id = iterator.next();
                if (!otherFilter.contains(id)) continue;
                tmpIds.add(id);
            }
            this.sortedIds = tmpIds;
            Collections.sort(this.sortedIds);
        }
        if (!this.filteringConnections) {
            this.filteringConnections = otherFilter.filteringConnections;
            this.connections.addAll(otherFilter.connections);
        } else if (otherFilter.filteringConnections) {
            HashSet<NetworkConnection> tmpConnections = new HashSet<NetworkConnection>();
            for (NetworkConnection connection : this.connections) {
                if (!otherFilter.connections.contains(connection)) continue;
                tmpConnections.add(connection);
            }
            this.connections = tmpConnections;
        }
        if (!this.filteringServices) {
            this.filteringServices = otherFilter.filteringServices;
            this.services.addAll(otherFilter.services);
        } else if (otherFilter.filteringServices) {
            HashSet<NetworkService> tmpServices = new HashSet<NetworkService>();
            for (NetworkService service : this.services) {
                if (!otherFilter.services.contains(service)) continue;
                tmpServices.add(service);
            }
            this.services = tmpServices;
        }
        if (!this.filteringHosts) {
            this.filteringHosts = otherFilter.filteringHosts;
            this.hosts.addAll(otherFilter.hosts);
        } else if (otherFilter.filteringHosts) {
            HashSet<IpAddress> tmpHosts = new HashSet<IpAddress>();
            for (IpAddress host : this.hosts) {
                if (!otherFilter.hosts.contains(host)) continue;
                tmpHosts.add(host);
            }
            this.hosts = tmpHosts;
        }
    }

    public void remove() {
        this.filteringIds = false;
        this.filteringConnections = false;
        this.filteringServices = false;
        this.filteringHosts = false;
        this.connections = new HashSet();
        this.sortedIds = new ArrayList();
        this.services = new HashSet();
        this.hosts = new HashSet();
    }

    public void filterConnections(NetworkConnection[] socketConnections) {
        this.connections.clear();
        for (NetworkConnection connection : socketConnections) {
            this.connections.add(connection);
        }
        this.filteringConnections = true;
    }

    public void filterIds(long[] socketIds) {
        this.sortedIds.clear();
        for (int i = 0; i < socketIds.length; ++i) {
            this.sortedIds.add(socketIds[i]);
        }
        Collections.sort(this.sortedIds);
        this.filteringIds = true;
    }

    public void filterServices(NetworkService[] networkServices) {
        this.services.clear();
        for (NetworkService service : networkServices) {
            this.services.add(service);
        }
        this.filteringServices = true;
    }

    public void filterHosts(NetworkHost[] networkHosts) {
        this.hosts.clear();
        for (NetworkHost host : networkHosts) {
            this.hosts.add(host.getAddress());
        }
        this.filteringHosts = true;
    }

    public boolean applies(IpAddress localAddress, char localPort, IpAddress remoteAddress, char remotePort, boolean isStreamSocket, long id, NetworkConnectionSideType side, String serviceName) {
        NetworkService service;
        NetworkConnection connection;
        if (this.filteringIds && id != -1L && !this.contains(id)) {
            return false;
        }
        if (this.filteringConnections && !this.connections.contains(connection = new NetworkConnection(localAddress, localPort, remoteAddress, remotePort, isStreamSocket))) {
            return false;
        }
        if (this.filteringServices && !this.services.contains(service = new NetworkService(serviceName, side != NetworkConnectionSideType.CLIENT ? localPort : remotePort, side, isStreamSocket))) {
            return false;
        }
        return !this.filteringHosts || this.hosts.contains(remoteAddress);
    }

    private boolean contains(long socketId) {
        return Collections.binarySearch(this.sortedIds, socketId) >= 0;
    }

    public int hashCode() {
        return this.connections.hashCode() ^ this.sortedIds.hashCode() ^ this.services.hashCode() ^ this.hosts.hashCode() + (this.filteringIds ? 3 : 5) + (this.filteringConnections ? 7 : 11) + (this.filteringServices ? 13 : 17) + (this.filteringHosts ? 19 : 23);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SocketFilter)) {
            return false;
        }
        SocketFilter tmpFilter = (SocketFilter)obj;
        return this.connections.equals(tmpFilter.connections) && this.sortedIds.equals(tmpFilter.sortedIds) && this.services.equals(tmpFilter.services) && this.hosts.equals(tmpFilter.hosts) && this.filteringIds == tmpFilter.filteringIds && this.filteringConnections == tmpFilter.filteringConnections && this.filteringServices == tmpFilter.filteringServices && this.filteringHosts == tmpFilter.filteringHosts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Filter socket connections (");
        builder.append(this.filteringConnections ? "X): " : " ): ");
        builder.append(this.connections.toString());
        builder.append(", socket ids (");
        builder.append(this.filteringIds ? "X): " : " ): ");
        builder.append(this.sortedIds);
        builder.append(", network services (");
        builder.append(this.filteringServices ? "X): " : " ): ");
        builder.append(this.services);
        builder.append(", network hosts (");
        builder.append(this.filteringHosts ? "X): " : " ): ");
        builder.append(this.hosts);
        return builder.toString();
    }

    private void appendSocketConnections(StringBuilder buffer) {
        if (this.connections.isEmpty()) {
            buffer.append("matching no socket connections");
            return;
        }
        boolean firstEntry = false;
        for (NetworkConnection nextConnection : this.connections) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("local=").append(nextConnection.getLocalAddress());
            buffer.append(":").append(nextConnection.getLocalPort());
            buffer.append(",remote=").append(nextConnection.getRemoteAddress());
            buffer.append(":").append(nextConnection.getRemotePort());
            firstEntry = false;
        }
    }

    private void appendSocketIds(StringBuilder buffer) {
        if (this.sortedIds.isEmpty()) {
            buffer.append("matching no socket id");
            return;
        }
        boolean firstEntry = false;
        for (long id : this.sortedIds) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("id=").append(id);
            firstEntry = false;
        }
    }

    private void appendNetworkServices(StringBuilder buffer) {
        if (this.services.isEmpty()) {
            buffer.append("matching no network services");
            return;
        }
        boolean firstEntry = false;
        for (NetworkService nextService : this.services) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("service=").append(nextService.getServiceName());
            buffer.append(":").append(nextService.getPort());
            if (nextService.getSideType() == NetworkConnectionSideType.SERVER) {
                buffer.append("[").append("server");
            } else if (nextService.getSideType() == NetworkConnectionSideType.CLIENT) {
                buffer.append("[").append("client");
            } else {
                buffer.append("[").append("unconnected");
            }
            buffer.append(",").append(nextService.isStream() ? "TCP" : "UDP").append("]");
            firstEntry = false;
        }
    }

    private void appendNetworkHosts(StringBuilder buffer) {
        if (this.hosts.isEmpty()) {
            buffer.append("matching no network hosts");
            return;
        }
        boolean firstEntry = false;
        for (IpAddress nextHost : this.hosts) {
            if (!firstEntry) {
                buffer.append(" || ");
            }
            buffer.append("address=").append(nextHost);
            firstEntry = false;
        }
    }
}

