/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.filter;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.resource.SynchronizationEventId;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public final class SynchronizationEventFilter {
    private final SynchronizationEventId[] events;
    private int hashCode;

    public SynchronizationEventFilter(SynchronizationEventId[] events) {
        this.events = events;
        Arrays.sort(events, SynchronizationEventId.getComparator());
    }

    public SynchronizationEventFilter(ResourceReader reader) throws IOException {
        this.events = new SynchronizationEventId[reader.readInt32()];
        for (int i = 0; i < this.events.length; ++i) {
            this.events[i] = new SynchronizationEventId(reader);
        }
        Arrays.sort(this.events, SynchronizationEventId.getComparator());
    }

    public SynchronizationEventId[] getEvents() {
        SynchronizationEventId[] result = new SynchronizationEventId[this.events.length];
        System.arraycopy(this.events, 0, result, 0, this.events.length);
        return result;
    }

    public boolean matches(long id) {
        return Arrays.binarySearch(this.events, new SynchronizationEventId(id, 0L)) >= 0;
    }

    public SynchronizationEventFilter narrow(SynchronizationEventFilter other) {
        return this.narrow(new SynchronizationEventFilter[]{other});
    }

    public SynchronizationEventFilter narrow(SynchronizationEventFilter[] others) {
        HashSet<SynchronizationEventId> filters = new HashSet<SynchronizationEventId>();
        filters.addAll(Arrays.asList(this.events));
        for (SynchronizationEventFilter f : others) {
            filters.retainAll(Arrays.asList(f.events));
        }
        return new SynchronizationEventFilter(filters.toArray(new SynchronizationEventId[filters.size()]));
    }

    public SynchronizationEventFilter widen(SynchronizationEventFilter other) {
        return this.widen(new SynchronizationEventFilter[]{other});
    }

    public SynchronizationEventFilter widen(SynchronizationEventFilter[] others) {
        HashSet<SynchronizationEventId> filters = new HashSet<SynchronizationEventId>();
        filters.addAll(Arrays.asList(this.events));
        for (SynchronizationEventFilter f : others) {
            filters.addAll(Arrays.asList(f.events));
        }
        return new SynchronizationEventFilter(filters.toArray(new SynchronizationEventId[filters.size()]));
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.events.length);
        for (SynchronizationEventId ev : this.events) {
            ev.write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SynchronizationEventFilter) {
            SynchronizationEventFilter filter = (SynchronizationEventFilter)obj;
            int h1 = this.hashCode;
            int h2 = filter.hashCode;
            if (h1 != h2 && h1 != 0 && h2 != 0) {
                return false;
            }
            return Arrays.equals(this.events, filter.events);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.events);
            this.hashCode = this.hashCode == 0 ? 1 : this.hashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        return Arrays.toString(this.events);
    }
}

