/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.framecombiner;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;
import com.sap.jvm.profiling.snapshot.framecombiner.FilterEntityMatcher;
import java.io.IOException;

public final class FilterEntity
implements CombinedEntity {
    private static final int VERSION = 0;
    private final MethodFilter filter;
    private final MethodFilter anyFilter;

    public FilterEntity(MethodFilter filter, MethodFilter anyFilter) {
        this.filter = filter;
        this.anyFilter = anyFilter;
    }

    public FilterEntity(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.filter = reader.readBoolean() ? new MethodFilter(reader) : null;
        this.anyFilter = new MethodFilter(reader);
    }

    public static FilterEntity[] create(MethodFilter[] filters) {
        FilterEntity[] entities = new FilterEntity[filters.length + 1];
        MethodFilter anyFilter = MethodFilter.createWide("any", filters, true);
        for (int i = 0; i < filters.length; ++i) {
            entities[i] = new FilterEntity(filters[i], anyFilter);
        }
        entities[filters.length] = new FilterEntity(null, anyFilter);
        return entities;
    }

    public MethodFilter getFilter() {
        return this.filter;
    }

    public MethodFilter getAnyFilter() {
        return this.anyFilter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterEntity) {
            FilterEntity other = (FilterEntity)obj;
            if (this.filter == null) {
                if (other.filter != null) {
                    return false;
                }
            } else {
                if (other.filter == null) {
                    return false;
                }
                if (!this.filter.equals(other.filter)) {
                    return false;
                }
            }
            return this.anyFilter.equals(other.anyFilter);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        if (this.filter != null) {
            result = this.filter.hashCode();
        }
        return result ^ this.anyFilter.hashCode();
    }

    public String toString() {
        if (this.filter == null) {
            return "other";
        }
        return this.filter.getName();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        if (this.filter == null) {
            writer.writeBoolean(false);
        } else {
            writer.writeBoolean(true);
            this.filter.write(writer);
        }
        this.anyFilter.write(writer);
    }

    @Override
    public boolean isOther() {
        return this.filter == null;
    }

    @Override
    public FilterEntityMatcher createMatcher() {
        return new FilterEntityMatcher(this.filter, this.anyFilter);
    }
}

