/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.framecombiner;

import com.sap.jvm.profiling.core.type.MethodLocationManager;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntityMatcher;

public class FilterEntityMatcher
implements CombinedEntityMatcher {
    private static final int MATCHES_FILTER = 1;
    private static final int MATCHES_ONLY_ANY = 2;
    private final int[] cache;
    private final boolean isOther;

    public FilterEntityMatcher(MethodFilter filter, MethodFilter anyFilter) {
        this.isOther = filter == null;
        MethodLocationManager manager = anyFilter.getSession().getMethodLocationManager();
        int maxLocationIndex = manager.getMaxLocationIndex();
        int cacheSize = (maxLocationIndex + 16) / 16;
        this.cache = new int[cacheSize];
        for (int i = 1; i <= maxLocationIndex; ++i) {
            MethodObject method = manager.getLocation(i).getMethod();
            if (!anyFilter.matches(method)) continue;
            int tag = 2;
            if (filter != null && filter.matches(method)) {
                tag = 1;
            }
            int cacheIndex = i >> 4;
            int shift = (i & 0xF) << 1;
            int n = cacheIndex;
            this.cache[n] = this.cache[n] | tag << shift;
        }
    }

    @Override
    public int getBottomMostBottom(StackFrames stack, boolean allowInterleaved, int bottom, int top) {
        assert (bottom <= top);
        if (bottom == top) {
            return -1;
        }
        if (this.isOther) {
            for (int i = bottom; i < top; ++i) {
                int shift;
                int locationIndex = stack.getMethodLocationIndex(i);
                int cacheIndex = locationIndex >> 4;
                int tag = this.cache[cacheIndex] >>> (shift = (locationIndex & 0xF) << 1) & 3;
                if (tag != 2) continue;
                return -1;
            }
            return bottom;
        }
        for (int i = bottom; i < top; ++i) {
            int shift;
            int locationIndex = stack.getMethodLocationIndex(i);
            int cacheIndex = locationIndex >> 4;
            int tag = this.cache[cacheIndex] >>> (shift = (locationIndex & 0xF) << 1) & 3;
            if (tag == 1) {
                return i;
            }
            if (allowInterleaved || tag != 2) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getTopMostBottom(StackFrames stack, boolean allowInterleaved, int bottom, int top) {
        assert (bottom <= top);
        if (bottom == top) {
            return -1;
        }
        if (this.isOther) {
            return this.getBottomMostBottom(stack, allowInterleaved, bottom, top);
        }
        for (int i = top - 1; i >= bottom; --i) {
            int shift;
            int locationIndex = stack.getMethodLocationIndex(i);
            int cacheIndex = locationIndex >> 4;
            int tag = this.cache[cacheIndex] >>> (shift = (locationIndex & 0xF) << 1) & 3;
            if (tag == 1) {
                return i;
            }
            if (allowInterleaved || tag != 2) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getTopForBottom(StackFrames stack, int bottom, int top) {
        assert (bottom < top);
        if (this.isOther) {
            return top;
        }
        for (int i = bottom + 1; i < top; ++i) {
            int shift;
            int locationIndex = stack.getMethodLocationIndex(i);
            int cacheIndex = locationIndex >> 4;
            int tag = this.cache[cacheIndex] >>> (shift = (locationIndex & 0xF) << 1) & 3;
            if (tag != 2) continue;
            return i;
        }
        return top;
    }
}

