/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.Comparator;

public final class GcEventId
implements Comparable<GcEventId> {
    private final long gcNumber;
    private final int index;
    private static final Comparator<GcEventId> comparator = new Comparator<GcEventId>(){

        @Override
        public int compare(GcEventId o1, GcEventId o2) {
            return o1.compareTo(o2);
        }
    };

    public GcEventId(long gcNumber, int index) {
        this.gcNumber = gcNumber;
        this.index = index;
    }

    public GcEventId(ResourceReader reader) throws IOException {
        this.gcNumber = reader.readInt64();
        this.index = reader.readInt32();
    }

    public long getGcNumber() {
        return this.gcNumber;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return (int)(this.gcNumber >> 32 ^ (long)this.index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GcEventId) {
            GcEventId other = (GcEventId)obj;
            return this.gcNumber == other.gcNumber && this.index == other.index;
        }
        return false;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.gcNumber);
        writer.writeInt32(this.index);
    }

    @Override
    public int compareTo(GcEventId o) {
        if (this.gcNumber != o.gcNumber) {
            return this.gcNumber < o.gcNumber ? -1 : 1;
        }
        return this.index - o.index;
    }

    public static Comparator<GcEventId> getComparator() {
        return comparator;
    }
}

